/*
 * Decompiled with CFR 0.152.
 */
package net.atilist.harderthanwolves.block;

import java.util.Random;
import net.atilist.harderthanwolves.block.LazyBlockTemplate;
import net.atilist.harderthanwolves.recipe.DiamondDrillRecipeRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.MechanicalDevice;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_475;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.IntProperty;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.util.Identifier;

public class DiamondDrillBlock
extends LazyBlockTemplate
implements MechanicalDevice {
    public static final IntProperty TYPES = IntProperty.of((String)"types", (int)0, (int)1);

    public DiamondDrillBlock(Identifier identifier, class_15 material, float hardness, class_475 blockSounds) {
        super(identifier, material, hardness, blockSounds);
        this.method_1584(true);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(new Property[]{TYPES});
    }

    @Environment(value=EnvType.CLIENT)
    public int method_1621() {
        return 0;
    }

    public boolean method_1623() {
        return false;
    }

    public boolean method_1620() {
        return false;
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        boolean receivingPower = this.IsInputtingMechanicalPower(world, i, j, k);
        boolean on = this.isBlockOn(world, i, j, k);
        if (on != receivingPower) {
            world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
            if (receivingPower) {
                world.method_216(i, j, k, this.field_1915, this.method_1565() + random.nextInt(6));
                this.setBlockOn(world, i, j, k);
            } else {
                this.setBlockOff(world, i, j, k);
            }
        } else if (on) {
            BlockPosition targetPos = new BlockPosition(i, j, k);
            targetPos.AddFacingAsOffset(1);
            this.drillBlock(world, targetPos.i, targetPos.j, targetPos.k);
        }
    }

    public void setBlockOn(class_18 world, int x, int y, int z) {
        world.method_215(x, y, z, 1);
        world.method_243(x, y, z);
    }

    public void setBlockOff(class_18 world, int x, int y, int z) {
        world.method_215(x, y, z, 0);
        world.method_243(x, y, z);
    }

    public void method_1617(class_18 world, int i, int j, int k, Random random) {
        if (this.isBlockOn(world, i, j, k)) {
            for (int counter = 0; counter < 5; ++counter) {
                float smokeX = (float)i + random.nextFloat();
                float smokeY = (float)j + random.nextFloat() * 0.5f + 1.0f;
                float smokeZ = (float)k + random.nextFloat();
                world.method_178("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
            }
            if (random.nextInt(5) == 0) {
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.1f + random.nextFloat() * 0.1f, 1.25f + random.nextFloat() * 0.1f);
            }
        }
    }

    public boolean isBlockOn(class_18 world, int i, int j, int k) {
        return world.method_1778(i, j, k) > 0;
    }

    void drillBlock(class_18 world, int i, int j, int k) {
        if (!world.method_234(i, j, k)) {
            int targetId = world.method_1776(i, j, k);
            class_31 targetItem = new class_31(targetId, 1, world.method_1778(i, j, k));
            boolean drilledBlock = false;
            class_31 output = DiamondDrillRecipeRegistry.getInstance().getResult(targetItem);
            if (output != null) {
                if (output.field_751 == 0) {
                    output.field_751 = 1;
                }
                for (int iTempCount = 0; iTempCount < output.field_751; ++iTempCount) {
                    UnsortedUtils.EjectSingleItemWithRandomOffset((class_18)world, (int)i, (int)j, (int)k, (int)output.field_753, (int)output.method_722());
                }
                drilledBlock = true;
            }
            if (drilledBlock) {
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
                world.method_229(i, j, k, 0);
            }
        }
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        world.method_216(i, j, k, net.atilist.harderthanwolves.events.init.BlockListener.diamondDrill.field_1915, this.method_1565());
    }

    public boolean CanOutputMechanicalPower() {
        return false;
    }

    public boolean CanInputMechanicalPower() {
        return false;
    }

    public boolean IsInputtingMechanicalPower(class_18 world, int i, int j, int k) {
        BlockPosition targetPos = new BlockPosition(i, j, k);
        targetPos.AddFacingAsOffset(0);
        int iTargetid = world.method_1776(targetPos.i, targetPos.j, targetPos.k);
        if (iTargetid != BlockListener.axleBlock.field_1915) {
            return false;
        }
        AxleBlock axleBlock = (AxleBlock)BlockListener.axleBlock;
        return axleBlock.IsAxleOrientedTowardsFacing((class_14)world, targetPos.i, targetPos.j, targetPos.k, 0) && axleBlock.GetPowerLevel((class_14)world, targetPos.i, targetPos.j, targetPos.k) > 0;
    }

    public boolean IsOutputtingMechanicalPower(class_18 world, int i, int i1, int i2) {
        return false;
    }
}

