/*
 * Decompiled with CFR 0.152.
 */
package net.atilist.harderthanwolves.block;

import java.util.List;
import java.util.Random;
import net.atilist.harderthanwolves.block.LazyBlockTemplate;
import net.atilist.harderthanwolves.events.init.TextureListener;
import net.atilist.harderthanwolves.recipe.ReinforcedSawRecipeRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.api.EnvironmentInterfaces;
import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.block.OmniSlabBlock;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ItemListener;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.CustomBlockRendering;
import net.kozibrodka.wolves.utils.MechanicalDevice;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_124;
import net.minecraft.class_127;
import net.minecraft.class_13;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_31;
import net.minecraft.class_475;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.client.model.block.BlockWithInventoryRenderer;
import net.modificationstation.stationapi.api.client.model.block.BlockWithWorldRenderer;
import net.modificationstation.stationapi.api.util.Identifier;

@EnvironmentInterfaces(value={@EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithWorldRenderer.class), @EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithInventoryRenderer.class)})
public class ReinforcedSawBlock
extends LazyBlockTemplate
implements MechanicalDevice,
RotatableBlock,
BlockWithWorldRenderer,
BlockWithInventoryRenderer {
    private static int iSawTickRate = 10;
    public static final float fSawBaseHeight = 0.75f;
    private final int iSawTopTextureIndex = 56;
    private final int iSawSideTextureIndex = 57;
    private final int iSawBladeTextureIndex = 58;

    public ReinforcedSawBlock(Identifier identifier, class_15 material, float hardness, class_475 blockSounds) {
        super(identifier, material, hardness, blockSounds);
        this.method_1584(true);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
    }

    public int method_1626(class_14 blockAccess, int i, int j, int k, int iSide) {
        int iFacing = this.GetFacing(blockAccess, i, j, k);
        return iSide != iFacing ? TextureListener.reinforcedSawSide : TextureListener.reinforcedSawFace;
    }

    @Override
    public int method_1627(int iSide, int meta) {
        return iSide != 1 ? TextureListener.reinforcedSawSide : TextureListener.reinforcedSawFace;
    }

    public int method_1565() {
        return iSawTickRate;
    }

    public void method_1606(class_18 world, int i, int j, int k, int iFacing) {
        this.SetFacing(world, i, j, k, UnsortedUtils.getOppositeFacing((int)iFacing));
    }

    public void method_1614(class_18 world, int i, int j, int k, class_127 entityLiving) {
        int iFacing = UnsortedUtils.ConvertPlacingEntityOrientationToBlockFacing((class_127)entityLiving);
        this.SetFacing(world, i, j, k, iFacing);
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        super.method_1611(world, i, j, k);
        world.method_216(i, j, k, this.field_1915, this.method_1565());
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        return switch (iFacing) {
            case 0 -> class_25.method_94((double)i, (double)((float)j + 1.0f - 0.75f), (double)k, (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
            case 1 -> class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + 0.75f), (double)((float)k + 1.0f));
            case 2 -> class_25.method_94((double)i, (double)j, (double)((float)k + 1.0f - 0.75f), (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
            case 3 -> class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 0.75f));
            case 4 -> class_25.method_94((double)((float)i + 1.0f - 0.75f), (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
            default -> class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + 0.75f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
        };
    }

    public void method_1616(class_14 iblockaccess, int i, int j, int k) {
        int iFacing = this.GetFacing(iblockaccess, i, j, k);
        switch (iFacing) {
            case 0: {
                this.method_1578(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                break;
            }
            case 2: {
                this.method_1578(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                break;
            }
            case 4: {
                this.method_1578(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            default: {
                this.method_1578(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
            }
        }
    }

    public void method_1605() {
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        if (iid != BlockListener.axleBlock.field_1915 && iid != BlockListener.handCrank.field_1915) {
            world.method_216(i, j, k, this.field_1915, this.method_1565() + world.field_214.nextInt(6));
        } else {
            world.method_216(i, j, k, this.field_1915, this.method_1565());
        }
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        boolean bReceivingPower = this.IsInputtingMechanicalPower(world, i, j, k);
        boolean bOn = this.IsBlockOn((class_14)world, i, j, k);
        if (bOn != bReceivingPower) {
            world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
            this.EmitSawParticles(world, i, j, k, random);
            this.SetBlockOn(world, i, j, k, bReceivingPower);
            if (bReceivingPower) {
                world.method_216(i, j, k, this.field_1915, this.method_1565() + random.nextInt(6));
            }
        } else if (bOn) {
            int iFacing = this.GetFacing((class_14)world, i, j, k);
            BlockPosition targetPos = new BlockPosition(i, j, k);
            targetPos.AddFacingAsOffset(iFacing);
            if (!this.AttemptToSawBlock(world, targetPos.i, targetPos.j, targetPos.k, random)) {
                this.BreakSaw(world, i, j, k);
            }
        }
    }

    public void method_1617(class_18 world, int i, int j, int k, Random random) {
        if (this.IsBlockOn((class_14)world, i, j, k)) {
            this.EmitSawParticles(world, i, j, k, random);
        }
    }

    public void method_1615(class_18 world, int i, int j, int k, class_57 entity) {
        if (this.IsBlockOn((class_14)world, i, j, k) && entity instanceof class_127) {
            int iFacing = this.GetFacing((class_14)world, i, j, k);
            float fHalfLength = 0.3125f;
            float fHalfWidth = 0.0078125f;
            float fBlockHeight = 0.25f;
            class_25 sawBox = switch (iFacing) {
                case 0 -> class_25.method_94((double)(0.5f - fHalfLength), (double)0.0, (double)(0.5f - fHalfWidth), (double)(0.5f + fHalfLength), (double)fBlockHeight, (double)(0.5f + fHalfWidth));
                case 1 -> class_25.method_94((double)(0.5f - fHalfLength), (double)(1.0f - fBlockHeight), (double)(0.5f - fHalfWidth), (double)(0.5f + fHalfLength), (double)1.0, (double)(0.5f + fHalfWidth));
                case 2 -> class_25.method_94((double)(0.5f - fHalfLength), (double)(0.5f - fHalfWidth), (double)0.0, (double)(0.5f + fHalfLength), (double)(0.5f + fHalfWidth), (double)fBlockHeight);
                case 3 -> class_25.method_94((double)(0.5f - fHalfLength), (double)(0.5f - fHalfWidth), (double)(1.0f - fBlockHeight), (double)(0.5f + fHalfLength), (double)(0.5f + fHalfWidth), (double)1.0);
                case 4 -> class_25.method_94((double)0.0, (double)(0.5f - fHalfWidth), (double)(0.5f - fHalfLength), (double)fBlockHeight, (double)(0.5f + fHalfWidth), (double)(0.5f + fHalfLength));
                default -> class_25.method_94((double)(1.0f - fBlockHeight), (double)(0.5f - fHalfWidth), (double)(0.5f - fHalfLength), (double)1.0, (double)(0.5f + fHalfWidth), (double)(0.5f + fHalfLength));
            };
            sawBox = sawBox.method_98((double)i, (double)j, (double)k);
            List collisionList = null;
            collisionList = world.method_175(class_127.class, sawBox);
            if (collisionList != null && collisionList.size() > 0) {
                for (int iTempListIndex = 0; iTempListIndex < collisionList.size(); ++iTempListIndex) {
                    class_127 tempTargetEntity = (class_127)collisionList.get(iTempListIndex);
                    if (!tempTargetEntity.method_1355((class_57)null, 4)) continue;
                    world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
                    this.EmitBloodParticles(world, i, j, k, world.field_214);
                }
            }
        }
    }

    public int GetFacing(class_14 iBlockAccess, int i, int j, int k) {
        return iBlockAccess.method_1778(i, j, k) & 7;
    }

    public void SetFacing(class_18 world, int i, int j, int k, int iFacing) {
        int iMetaData = world.method_1778(i, j, k) & 0xFFFFFFF8;
        world.method_215(i, j, k, iMetaData |= iFacing);
    }

    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int k) {
        int iFacing = this.GetFacing(iBlockAccess, i, j, k);
        return iFacing != 0;
    }

    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int k) {
        int iFacing = this.GetFacing(iBlockAccess, i, j, k);
        return iFacing != 0 && iFacing != 1;
    }

    public void Rotate(class_18 world, int i, int j, int k, boolean bReverse) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        int iNewFacing = UnsortedUtils.RotateFacingAroundJ((int)iFacing, (boolean)bReverse);
        if (iNewFacing != iFacing) {
            this.SetFacing(world, i, j, k, iNewFacing);
            world.method_202(i, j, k, i, j, k);
            world.method_216(i, j, k, this.field_1915, this.method_1565());
            world.method_235(i, j, k, this.field_1915);
        }
        UnsortedUtils.DestroyHorizontallyAttachedAxles((class_18)world, (int)i, (int)j, (int)k);
    }

    public boolean IsBlockOn(class_14 iBlockAccess, int i, int j, int k) {
        return (iBlockAccess.method_1778(i, j, k) & 8) > 0;
    }

    public void SetBlockOn(class_18 world, int i, int j, int k, boolean bOn) {
        int iMetaData = world.method_1778(i, j, k) & 7;
        if (bOn) {
            iMetaData |= 8;
        }
        world.method_215(i, j, k, iMetaData);
        world.method_243(i, j, k);
    }

    void EmitSawParticles(class_18 world, int i, int j, int k, Random random) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        float fBladeXPos = i;
        float fBladeYPos = j;
        float fBladeZPos = k;
        float fBladeXExtent = 0.0f;
        float fBladeZExtent = 0.0f;
        switch (iFacing) {
            case 0: {
                fBladeXPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 1: {
                fBladeXPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeYPos += 1.0f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 2: {
                fBladeXPos += 0.5f;
                fBladeYPos += 0.5f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 3: {
                fBladeXPos += 0.5f;
                fBladeYPos += 0.5f;
                fBladeZPos += 1.0f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 4: {
                fBladeYPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeZExtent = 1.0f;
                break;
            }
            default: {
                fBladeYPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeXPos += 1.0f;
                fBladeZExtent = 1.0f;
            }
        }
        for (int counter = 0; counter < 5; ++counter) {
            float smokeX = fBladeXPos + (random.nextFloat() - 0.5f) * fBladeXExtent;
            float smokeY = fBladeYPos + random.nextFloat() * 0.1f;
            float smokeZ = fBladeZPos + (random.nextFloat() - 0.5f) * fBladeZExtent;
            world.method_178("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    void EmitBloodParticles(class_18 world, int i, int j, int k, Random random) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        BlockPosition iTargetPos = new BlockPosition(i, j, k);
        iTargetPos.AddFacingAsOffset(iFacing);
        for (int counter = 0; counter < 10; ++counter) {
            float smokeX = (float)iTargetPos.i + random.nextFloat();
            float smokeY = (float)iTargetPos.j + random.nextFloat();
            float smokeZ = (float)iTargetPos.k + random.nextFloat();
            world.method_178("reddust", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    boolean AttemptToSawBlock(class_18 world, int i, int j, int k, Random random) {
        if (!world.method_234(i, j, k)) {
            int iTargetid = world.method_1776(i, j, k);
            class_31 targetItem = new class_31(iTargetid, 1, world.method_1778(i, j, k));
            boolean bSawedBlock = false;
            class_17 targetBlock = class_17.field_1937[iTargetid];
            boolean bRemoveOriginalBlockIfSawed = true;
            if (iTargetid == BlockListener.omniSlab.field_1915 && !((OmniSlabBlock)BlockListener.omniSlab).IsSlabWood((class_14)world, i, j, k)) {
                return false;
            }
            class_31 output = ReinforcedSawRecipeRegistry.getInstance().getResult(targetItem);
            if (output != null) {
                if (output.field_751 == 0) {
                    output.field_751 = 1;
                }
                for (int iTempCount = 0; iTempCount < output.field_751; ++iTempCount) {
                    UnsortedUtils.EjectSingleItemWithRandomOffset((class_18)world, (int)i, (int)j, (int)k, (int)output.field_753, (int)output.method_722());
                }
                bSawedBlock = true;
            } else if (iTargetid != class_17.field_1832.field_1915 && iTargetid != class_17.field_1872.field_1915 && iTargetid != class_17.field_1848.field_1915 && iTargetid != BlockListener.hempCrop.field_1915) {
                if (iTargetid != class_17.field_1875.field_1915 && targetBlock != null) {
                    class_15 targetMaterial = targetBlock.field_1900;
                    if (targetMaterial != class_15.field_982) {
                        if (targetMaterial.method_905()) {
                            return false;
                        }
                    } else {
                        targetBlock.method_1592(world, i, j, k, world.method_1778(i, j, k));
                        bSawedBlock = true;
                    }
                }
            } else {
                targetBlock.method_1592(world, i, j, k, world.method_1778(i, j, k));
                bSawedBlock = true;
            }
            if (bSawedBlock) {
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
                this.EmitSawParticles(world, i, j, k, random);
                if (bRemoveOriginalBlockIfSawed) {
                    world.method_229(i, j, k, 0);
                }
            }
        }
        return true;
    }

    public void BreakSaw(class_18 world, int i, int j, int k) {
        int iTemp;
        for (iTemp = 0; iTemp < 2; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset((class_18)world, (int)i, (int)j, (int)k, (int)ItemListener.gear.field_461, (int)0);
        }
        for (iTemp = 0; iTemp < 2; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset((class_18)world, (int)i, (int)j, (int)k, (int)class_17.field_1949.field_1915, (int)0);
        }
        for (iTemp = 0; iTemp < 2; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset((class_18)world, (int)i, (int)j, (int)k, (int)class_124.field_478.field_461, (int)0);
        }
        for (iTemp = 0; iTemp < 1; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset((class_18)world, (int)i, (int)j, (int)k, (int)ItemListener.belt.field_461, (int)0);
        }
        world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
        world.method_229(i, j, k, 0);
    }

    public boolean CanOutputMechanicalPower() {
        return false;
    }

    public boolean CanInputMechanicalPower() {
        return true;
    }

    public boolean IsInputtingMechanicalPower(class_18 world, int i, int j, int k) {
        int iSawFacing = this.GetFacing((class_14)world, i, j, k);
        for (int iFacing = 0; iFacing <= 5; ++iFacing) {
            AxleBlock axleBlock;
            if (iFacing == iSawFacing) continue;
            BlockPosition targetPos = new BlockPosition(i, j, k);
            targetPos.AddFacingAsOffset(iFacing);
            int iTargetid = world.method_1776(targetPos.i, targetPos.j, targetPos.k);
            if (iTargetid != BlockListener.axleBlock.field_1915 || !(axleBlock = (AxleBlock)BlockListener.axleBlock).IsAxleOrientedTowardsFacing((class_14)world, targetPos.i, targetPos.j, targetPos.k, iFacing) || axleBlock.GetPowerLevel((class_14)world, targetPos.i, targetPos.j, targetPos.k) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean IsOutputtingMechanicalPower(class_18 world, int i, int j, int l) {
        return false;
    }

    public boolean renderWorld(class_13 tileRenderer, class_14 tileView, int x, int y, int z) {
        float f = 0.5f;
        float f1 = 0.5f;
        float f2 = 0.75f;
        int l = this.GetFacing(tileView, x, y, z);
        switch (l) {
            case 0: {
                this.method_1578(0.5f - f1, 1.0f - f2, 0.5f - f, 0.5f + f1, 1.0f, 0.5f + f);
                break;
            }
            case 1: {
                this.method_1578(0.5f - f1, 0.0f, 0.5f - f, 0.5f + f1, f2, 0.5f + f);
                break;
            }
            case 2: {
                this.method_1578(0.5f - f1, 0.5f - f, 1.0f - f2, 0.5f + f1, 0.5f + f, 1.0f);
                break;
            }
            case 3: {
                this.method_1578(0.5f - f1, 0.5f - f, 0.0f, 0.5f + f1, 0.5f + f, f2);
                break;
            }
            case 4: {
                this.method_1578(1.0f - f2, 0.5f - f1, 0.5f - f, 1.0f, 0.5f + f1, 0.5f + f);
                break;
            }
            default: {
                this.method_1578(0.0f, 0.5f - f1, 0.5f - f, f2, 0.5f + f1, 0.5f + f);
            }
        }
        tileRenderer.method_76((class_17)this, x, y, z);
        f = 0.3125f;
        f1 = 0.0078125f;
        f2 = 0.25f;
        switch (l) {
            case 0: {
                this.method_1578(0.5f - f, 0.0f, 0.5f - f1, 0.5f + f, 0.999f, 0.5f + f1);
                break;
            }
            case 1: {
                this.method_1578(0.5f - f, 0.001f, 0.5f - f1, 0.5f + f, 1.0f, 0.5f + f1);
                break;
            }
            case 2: {
                this.method_1578(0.5f - f, 0.5f - f1, 0.0f, 0.5f + f, 0.5f + f1, f2);
                break;
            }
            case 3: {
                this.method_1578(0.5f - f, 0.5f - f1, 1.0f - f2, 0.5f + f, 0.5f + f1, 1.0f);
                break;
            }
            case 4: {
                this.method_1578(0.0f, 0.5f - f1, 0.5f - f, f2, 0.5f + f1, 0.5f + f);
                break;
            }
            default: {
                this.method_1578(1.0f - f2, 0.5f - f1, 0.5f - f, 1.0f, 0.5f + f1, 0.5f + f);
            }
        }
        CustomBlockRendering.renderStandardBlockWithTexture((class_13)tileRenderer, (class_17)this, (int)x, (int)y, (int)z, (int)TextureListener.reinforcedSawSaw);
        return true;
    }

    public void renderInventory(class_13 tileRenderer, int meta) {
        this.method_1605();
        CustomBlockRendering.RenderInvBlockWithMetaData((class_13)tileRenderer, (class_17)this, (float)-0.5f, (float)-0.5f, (float)-0.5f, (int)1);
        float f = 0.3125f;
        float f1 = 0.0078125f;
        this.method_1578(0.5f - f, 0.001f, 0.5f - f1, 0.5f + f, 1.0f, 0.5f + f1);
        CustomBlockRendering.RenderInvBlockWithTexture((class_13)tileRenderer, (class_17)this, (float)-0.5f, (float)-0.5f, (float)-0.5f, (int)TextureListener.reinforcedSawSaw);
    }
}

