/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.hotkettles.block;

import com.matthewperiut.hotkettles.blockentity.KettleBlockEntity;
import com.matthewperiut.hotkettles.components.HotKettleComponents;
import com.matthewperiut.hotkettles.item.HotKettleItems;
import com.matthewperiut.hotkettles.item.KettleItem;
import com.mojang.serialization.MapCodec;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KettleBlock
extends BaseEntityBlock {
    public static final IntegerProperty KETTLE_TYPE = IntegerProperty.create((String)"kettle_type", (int)0, (int)6);
    protected static final VoxelShape SHAPE = Block.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);

    public KettleBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(state -> (Integer)state.getValue((Property)KETTLE_TYPE) == 6 ? 12 : 0));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)KETTLE_TYPE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return KettleBlock.simpleCodec(KettleBlock::new);
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        builder.add(new Property[]{KETTLE_TYPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getClockWise(Direction.Axis.Y).getClockWise(Direction.Axis.Y);
        try {
            Item item = context.getItemInHand().getItem();
            if (item instanceof KettleItem) {
                KettleItem kettleItem = (KettleItem)item;
                return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction)).setValue((Property)KETTLE_TYPE, (Comparable)Integer.valueOf(kettleItem.kettle_type));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction)).setValue((Property)KETTLE_TYPE, (Comparable)Integer.valueOf(0));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KettleBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        int state_type = (Integer)state.getValue((Property)KETTLE_TYPE);
        for (RegistrySupplier<Item> kettle : HotKettleItems.kettles) {
            Object object = kettle.get();
            if (!(object instanceof KettleItem)) continue;
            KettleItem k = (KettleItem)((Object)object);
            if (k.kettle_type != state_type) continue;
            ItemStack stack = new ItemStack((ItemLike)k);
            stack.set((DataComponentType)HotKettleComponents.LIQUID_LEVEL_COMPONENT.get(), (Object)((KettleBlockEntity)world.getBlockEntity((BlockPos)pos)).liquidLevel);
            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack));
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() == Items.CACTUS) {
            return KettleBlock.fillKettleLiquid(world, pos, player, stack, state, SoundEvents.BUCKET_EMPTY, 1, true);
        }
        if (stack.getItem() == Items.WATER_BUCKET) {
            return KettleBlock.fillKettleLiquid(world, pos, player, stack, state, SoundEvents.BUCKET_EMPTY, 2, false);
        }
        if (stack.getItem() == Items.MILK_BUCKET) {
            return KettleBlock.fillKettleLiquid(world, pos, player, stack, state, SoundEvents.BUCKET_EMPTY, 3, false);
        }
        if (stack.getItem() == Items.LAVA_BUCKET) {
            return KettleBlock.fillKettleLiquid(world, pos, player, stack, state, SoundEvents.BUCKET_EMPTY, 6, false);
        }
        if (stack.getItem() == Items.BUCKET) {
            if (((KettleBlockEntity)world.getBlockEntity((BlockPos)pos)).liquidLevel == 5) {
                if ((Integer)world.getBlockState(pos).getValue((Property)KETTLE_TYPE) == 2) {
                    return KettleBlock.takeKettleLiquid(world, pos, player, stack, state, SoundEvents.BUCKET_FILL, Items.WATER_BUCKET);
                }
                if ((Integer)world.getBlockState(pos).getValue((Property)KETTLE_TYPE) == 3) {
                    return KettleBlock.takeKettleLiquid(world, pos, player, stack, state, SoundEvents.BUCKET_FILL, Items.MILK_BUCKET);
                }
                if ((Integer)world.getBlockState(pos).getValue((Property)KETTLE_TYPE) == 6) {
                    return KettleBlock.takeKettleLiquid(world, pos, player, stack, state, SoundEvents.BUCKET_FILL, Items.LAVA_BUCKET);
                }
            }
            return KettleBlock.takeKettleLiquid(world, pos, player, stack, state, SoundEvents.BUCKET_FILL, Items.BUCKET);
        }
        if ((Integer)world.getBlockState(pos).getValue((Property)KETTLE_TYPE) == 2) {
            if (stack.getItem() == Items.COCOA_BEANS) {
                return KettleBlock.fillKettleLiquid(world, pos, player, stack, state, SoundEvents.BUCKET_EMPTY, 4, true);
            }
            if (stack.getItem() == Items.APPLE) {
                return KettleBlock.fillKettleLiquid(world, pos, player, stack, state, SoundEvents.BUCKET_EMPTY, 5, true);
            }
        }
        if (!world.isClientSide() && stack.isEmpty()) {
            if ((Integer)state.getValue((Property)KETTLE_TYPE) == 0) {
                player.displayClientMessage(Component.nullToEmpty((String)"Use water bucket, milk bucket, lava bucket, or cactus on kettle to fill."), false);
            } else if ((Integer)state.getValue((Property)KETTLE_TYPE) == 2) {
                player.displayClientMessage(Component.nullToEmpty((String)"Use cocoa beans or apple on the water kettle to brew new liquid."), false);
            } else {
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof KettleBlockEntity) {
                    KettleBlockEntity kettle = (KettleBlockEntity)blockEntity;
                    if (!kettle.hot()) {
                        player.displayClientMessage(Component.nullToEmpty((String)"Put fire, lava, or lit furnace under kettle to heat it up."), false);
                    } else {
                        player.displayClientMessage(Component.nullToEmpty((String)"Collect liquid with an empty mug."), false);
                    }
                }
            }
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    static InteractionResult fillKettleLiquid(Level world, BlockPos pos, Player player, ItemStack stack, BlockState state, SoundEvent soundEvent, int nextKettleType, boolean decrement) {
        if (!world.isClientSide()) {
            if (decrement) {
                player.getMainHandItem().shrink(1);
            } else {
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET)));
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)KETTLE_TYPE, (Comparable)Integer.valueOf(nextKettleType)));
            world.playSound((Entity)((Player)null), pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PLACE, pos);
            ((KettleBlockEntity)world.getBlockEntity(pos)).setLiquidLevel(5);
            ((KettleBlockEntity)world.getBlockEntity(pos)).setLiquidHorizontalOffset(nextKettleType * 2);
        }
        return InteractionResult.SUCCESS;
    }

    static InteractionResult takeKettleLiquid(Level world, BlockPos pos, Player player, ItemStack stack, BlockState state, SoundEvent soundEvent, Item replaced) {
        if (!world.isClientSide()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)replaced)));
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)KETTLE_TYPE, (Comparable)Integer.valueOf(0)));
            world.playSound((Entity)((Player)null), pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PICKUP, pos);
            ((KettleBlockEntity)world.getBlockEntity(pos)).setLiquidLevel(0);
            ((KettleBlockEntity)world.getBlockEntity(pos)).setLiquidHorizontalOffset(0);
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        int state_type = (Integer)state.getValue((Property)KETTLE_TYPE);
        for (RegistrySupplier<Item> kettle : HotKettleItems.kettles) {
            Object object = kettle.get();
            if (!(object instanceof KettleItem)) continue;
            KettleItem k = (KettleItem)((Object)object);
            if (k.kettle_type != state_type) continue;
            ItemStack stack = new ItemStack((ItemLike)k);
            stack.set((DataComponentType)HotKettleComponents.LIQUID_LEVEL_COMPONENT.get(), (Object)((KettleBlockEntity)world.getBlockEntity((BlockPos)pos)).liquidLevel);
            return stack;
        }
        return super.getCloneItemStack(world, pos, state, includeData);
    }
}

