/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.hotkettles.item;

import com.matthewperiut.hotkettles.block.KettleBlock;
import com.matthewperiut.hotkettles.blockentity.KettleBlockEntity;
import com.matthewperiut.hotkettles.components.HotKettleComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class KettleItem
extends BlockItem {
    public int kettle_type = 0;
    public static int liquidLevel = -1;

    public KettleItem(Block block, Item.Properties settings, int kettle_type) {
        super(block, settings.stacksTo(1));
        this.kettle_type = kettle_type;
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)("block." + BuiltInRegistries.ITEM.getKey((Object)this).toString().replace(":", ".")));
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        Integer liquidLevelValue = (Integer)context.getItemInHand().get((DataComponentType)HotKettleComponents.LIQUID_LEVEL_COMPONENT.get());
        liquidLevel = liquidLevelValue != null ? liquidLevelValue : -1;
        return super.updatePlacementContext(context);
    }

    public InteractionResult place(BlockPlaceContext context) {
        InteractionResult result = super.place(context);
        if (result == InteractionResult.SUCCESS) {
            if (liquidLevel > -1) {
                ((KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos())).setLiquidLevel(liquidLevel);
            } else if ((Integer)context.getLevel().getBlockState(context.getClickedPos()).getValue((Property)KettleBlock.KETTLE_TYPE) == 0) {
                ((KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos())).setLiquidLevel(0);
            } else {
                ((KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos())).setLiquidLevel(5);
            }
        }
        return result;
    }

    public int getBarWidth(ItemStack stack) {
        Integer liquidLevel = (Integer)stack.get((DataComponentType)HotKettleComponents.LIQUID_LEVEL_COMPONENT.get());
        if (liquidLevel != null) {
            return (int)((float)liquidLevel.intValue() * 2.6f);
        }
        return 13;
    }

    public int getBarColor(ItemStack stack) {
        return 65280;
    }

    public boolean isBarVisible(ItemStack stack) {
        Integer liquidLevel = (Integer)stack.get((DataComponentType)HotKettleComponents.LIQUID_LEVEL_COMPONENT.get());
        return liquidLevel != null && liquidLevel != 5;
    }
}

