/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.hotkettles.neoforge.mixin;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.minecraft.client.Minecraft;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.language.IModInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class EarlyVersionCheckMixin {
    private static boolean versionChecked = false;

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;getNanos()J")})
    private static void checkVersionCompatibility(CallbackInfo ci) {
        if (!versionChecked) {
            versionChecked = true;
            try {
                String neoforgeVersion = FMLLoader.getCurrent().getVersionInfo().neoForgeVersion();
                String architecturyVersion = ((IModInfo)FMLLoader.getCurrent().getLoadingModList().getModFileById("architectury").getMods().get(0)).getVersion().toString();
                if (EarlyVersionCheckMixin.isNeoForgeVersionTooHigh(neoforgeVersion) && EarlyVersionCheckMixin.isArchitecturyVersionTooLow(architecturyVersion)) {
                    String message = "This version of architectury api can only use NeoForge 21.10.34-beta or lower.\n\nCurrent NeoForge: " + neoforgeVersion + "\nCurrent Architectury: " + architecturyVersion + "\n\nIf a newer version of architectury api exists, you can also update to that instead.";
                    EarlyVersionCheckMixin.showErrorDialog(message);
                    throw new RuntimeException("Incompatible mod versions: NeoForge " + neoforgeVersion + " with Architectury " + architecturyVersion);
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException && e.getMessage().contains("Incompatible mod versions")) {
                    throw e;
                }
                System.err.println("[HotKettles] Failed to check version compatibility: " + e.getMessage());
            }
        }
    }

    private static boolean isNeoForgeVersionTooHigh(String version) {
        try {
            String[] parts = version.replace("-beta", "").split("\\.");
            if (parts.length < 3) {
                return false;
            }
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            int patch = Integer.parseInt(parts[2]);
            if (major > 21) {
                return true;
            }
            if (major < 21) {
                return false;
            }
            if (minor > 10) {
                return true;
            }
            if (minor < 10) {
                return false;
            }
            return patch > 34;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isArchitecturyVersionTooLow(String version) {
        try {
            String[] parts = version.split("\\.");
            if (parts.length < 3) {
                return false;
            }
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            int patch = Integer.parseInt(parts[2]);
            if (major < 18) {
                return true;
            }
            if (major > 18) {
                return false;
            }
            if (minor < 0) {
                return true;
            }
            if (minor > 0) {
                return false;
            }
            return patch <= 6;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void showErrorDialog(String message) {
        try {
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(null, message, "Mod Compatibility Error", 0));
            System.err.println("[HotKettles] " + message);
            System.err.println("[HotKettles] Exiting due to incompatible mod versions.");
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("[HotKettles] Failed to show error dialog: " + e.getMessage());
            System.err.println("[HotKettles] " + message);
            System.exit(1);
        }
    }
}

