/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.hotkettles.block;

import com.matthewperiut.hotkettles.item.HotKettleItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MugBlock
extends Block {
    public static final Property<Boolean> HOT = BooleanProperty.create((String)"hot");
    public static final Property<Boolean> UPSIDE_DOWN = BooleanProperty.create((String)"upside_down");
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UPSIDE_DOWN});
        builder.add(new Property[]{HOT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean isSneaking = context.getPlayer().isShiftKeyDown();
        boolean hot = context.getItemInHand().getDamageValue() == 1;
        return (BlockState)((BlockState)this.defaultBlockState().setValue(UPSIDE_DOWN, (Comparable)Boolean.valueOf(isSneaking))).setValue(HOT, (Comparable)Boolean.valueOf(hot));
    }

    public MugBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(HOT, (Comparable)Boolean.valueOf(false))).setValue(UPSIDE_DOWN, (Comparable)Boolean.valueOf(true)));
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        return super.playerWillDestroy(world, pos, state, player);
    }

    protected void spawnAfterBreak(BlockState state, ServerLevel world, BlockPos pos, ItemStack tool, boolean dropExperience) {
        boolean hot = (Boolean)state.getValue(HOT);
        ItemStack stack = new ItemStack((ItemLike)state.getBlock().asItem());
        if (!hot) {
            if (stack.getItem().equals(HotKettleItems.HOT_WATER.get())) {
                stack = new ItemStack((ItemLike)HotKettleItems.CUP_OF_WATER.get());
            }
            if (stack.getItem().equals(HotKettleItems.HOT_CIDER.get())) {
                stack = new ItemStack((ItemLike)HotKettleItems.APPLE_CIDER.get());
            }
            if (stack.getItem().equals(HotKettleItems.HOT_COCOA.get())) {
                stack = new ItemStack((ItemLike)HotKettleItems.BITTER_WATER.get());
            }
            if (stack.getItem().equals(HotKettleItems.STEAMED_MILK.get())) {
                stack = new ItemStack((ItemLike)HotKettleItems.CUP_OF_MILK.get());
            }
        }
        world.addFreshEntity((Entity)new ItemEntity((Level)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack));
        super.spawnAfterBreak(state, world, pos, tool, dropExperience);
    }
}

