/*
 * Decompiled with CFR 0.152.
 */
package dev.unowly.challengetimer;

import dev.unowly.challengetimer.events.PlayerEventHandler;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChallengeTimer
extends JavaPlugin {
    private Instant globalStartTime;
    private boolean globalIsRunning = false;
    private boolean globalIsPaused = false;
    private Duration globalPausedDuration = Duration.ZERO;
    private Instant globalPauseStartTime;
    private Map<UUID, Instant> playerStartTimes = new HashMap<UUID, Instant>();
    private Map<UUID, Duration> playerPausedDurations = new HashMap<UUID, Duration>();
    private Map<UUID, Instant> playerPauseStartTimes = new HashMap<UUID, Instant>();
    private Map<UUID, Boolean> playerIsRunning = new HashMap<UUID, Boolean>();
    private Map<UUID, Boolean> playerIsPaused = new HashMap<UUID, Boolean>();
    private BukkitRunnable timerTask;
    private PlayerEventHandler eventHandler;
    private File dataFile;
    private FileConfiguration dataConfig;
    private boolean individualTimers;
    private String timerLabel;
    private String timerDivider;
    private String startLabel;
    private String stopLabel;
    private TextColor timerTitleColor;
    private TextColor startLabelColor;
    private TextColor stopLabelColor;
    private TextColor daysColor;
    private TextColor hoursColor;
    private TextColor minutesColor;
    private TextColor secondsColor;
    private TextColor separatorColor;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.setupDataFile();
        this.loadTimerData();
        this.eventHandler = new PlayerEventHandler(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.eventHandler, (Plugin)this);
        if (this.shouldShowTimer()) {
            this.startTimerTask();
        }
        this.getLogger().info("ChallengeTimer Plugin loaded!");
    }

    public void onDisable() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.saveTimerData();
        this.getLogger().info("ChallengeTimer Plugin deactivated!");
    }

    private void setupDataFile() {
        this.dataFile = new File(this.getDataFolder(), "timer_data.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.getParentFile().mkdirs();
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create timer_data.yml file: " + e.getMessage());
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    private void saveTimerData() {
        if (this.dataConfig == null) {
            return;
        }
        this.dataConfig.set("global.isRunning", (Object)this.globalIsRunning);
        this.dataConfig.set("global.isPaused", (Object)this.globalIsPaused);
        this.dataConfig.set("global.startTime", this.globalStartTime != null ? this.globalStartTime.toString() : null);
        this.dataConfig.set("global.pausedDuration", (Object)this.globalPausedDuration.toString());
        this.dataConfig.set("global.pauseStartTime", this.globalPauseStartTime != null ? this.globalPauseStartTime.toString() : null);
        this.dataConfig.set("players", null);
        for (UUID playerId : this.playerStartTimes.keySet()) {
            String playerKey = "players." + playerId.toString();
            this.dataConfig.set(playerKey + ".isRunning", (Object)this.playerIsRunning.getOrDefault(playerId, false));
            this.dataConfig.set(playerKey + ".isPaused", (Object)this.playerIsPaused.getOrDefault(playerId, false));
            this.dataConfig.set(playerKey + ".startTime", this.playerStartTimes.get(playerId) != null ? this.playerStartTimes.get(playerId).toString() : null);
            this.dataConfig.set(playerKey + ".pausedDuration", (Object)this.playerPausedDurations.getOrDefault(playerId, Duration.ZERO).toString());
            this.dataConfig.set(playerKey + ".pauseStartTime", this.playerPauseStartTimes.get(playerId) != null ? this.playerPauseStartTimes.get(playerId).toString() : null);
        }
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save timer data: " + e.getMessage());
        }
    }

    private void loadTimerData() {
        if (this.dataConfig == null) {
            return;
        }
        this.globalIsRunning = this.dataConfig.getBoolean("global.isRunning", false);
        this.globalIsPaused = this.dataConfig.getBoolean("global.isPaused", false);
        String globalStartTimeStr = this.dataConfig.getString("global.startTime");
        if (globalStartTimeStr != null) {
            try {
                this.globalStartTime = Instant.parse(globalStartTimeStr);
            }
            catch (Exception e) {
                this.getLogger().warning("Could not parse global start time: " + e.getMessage());
                this.globalStartTime = null;
            }
        }
        String globalPausedDurationStr = this.dataConfig.getString("global.pausedDuration", "PT0S");
        try {
            this.globalPausedDuration = Duration.parse(globalPausedDurationStr);
        }
        catch (Exception e) {
            this.getLogger().warning("Could not parse global paused duration: " + e.getMessage());
            this.globalPausedDuration = Duration.ZERO;
        }
        String globalPauseStartTimeStr = this.dataConfig.getString("global.pauseStartTime");
        if (globalPauseStartTimeStr != null) {
            try {
                this.globalPauseStartTime = Instant.parse(globalPauseStartTimeStr);
            }
            catch (Exception e) {
                this.getLogger().warning("Could not parse global pause start time: " + e.getMessage());
                this.globalPauseStartTime = null;
            }
        }
        if (this.dataConfig.contains("players")) {
            for (String playerIdStr : this.dataConfig.getConfigurationSection("players").getKeys(false)) {
                try {
                    UUID playerId = UUID.fromString(playerIdStr);
                    String playerKey = "players." + playerIdStr;
                    this.playerIsRunning.put(playerId, this.dataConfig.getBoolean(playerKey + ".isRunning", false));
                    this.playerIsPaused.put(playerId, this.dataConfig.getBoolean(playerKey + ".isPaused", false));
                    String startTimeStr = this.dataConfig.getString(playerKey + ".startTime");
                    if (startTimeStr != null) {
                        this.playerStartTimes.put(playerId, Instant.parse(startTimeStr));
                    }
                    String pausedDurationStr = this.dataConfig.getString(playerKey + ".pausedDuration", "PT0S");
                    this.playerPausedDurations.put(playerId, Duration.parse(pausedDurationStr));
                    String pauseStartTimeStr = this.dataConfig.getString(playerKey + ".pauseStartTime");
                    if (pauseStartTimeStr == null) continue;
                    this.playerPauseStartTimes.put(playerId, Instant.parse(pauseStartTimeStr));
                }
                catch (Exception e) {
                    this.getLogger().warning("Could not parse player timer data for " + playerIdStr + ": " + e.getMessage());
                }
            }
        }
        if (this.globalIsPaused && this.globalPauseStartTime != null) {
            this.globalPausedDuration = this.globalPausedDuration.plus(Duration.between(this.globalPauseStartTime, Instant.now()));
            this.globalPauseStartTime = Instant.now();
        }
        for (UUID playerId : this.playerPauseStartTimes.keySet()) {
            Instant pauseStart;
            if (!this.playerIsPaused.getOrDefault(playerId, false).booleanValue() || (pauseStart = this.playerPauseStartTimes.get(playerId)) == null) continue;
            Duration currentPaused = this.playerPausedDurations.getOrDefault(playerId, Duration.ZERO);
            this.playerPausedDurations.put(playerId, currentPaused.plus(Duration.between(pauseStart, Instant.now())));
            this.playerPauseStartTimes.put(playerId, Instant.now());
        }
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.individualTimers = config.getBoolean("individual_timers", false);
        this.timerLabel = config.getString("text.timer_label", "Challenge Timer");
        this.timerDivider = config.getString("text.timer_divider", " | ");
        this.startLabel = config.getString("text.start_label", " \u25b6 ");
        this.stopLabel = config.getString("text.stop_label", " \u23f8 ");
        this.timerTitleColor = this.parseColor(config.getString("colors.timer_title", "gold"));
        this.startLabelColor = this.parseColor(config.getString("colors.start_label", "yellow"));
        this.stopLabelColor = this.parseColor(config.getString("colors.stop_label", "green"));
        this.daysColor = this.parseColor(config.getString("colors.days", "green"));
        this.hoursColor = this.parseColor(config.getString("colors.hours", "aqua"));
        this.minutesColor = this.parseColor(config.getString("colors.minutes", "yellow"));
        this.secondsColor = this.parseColor(config.getString("colors.seconds", "white"));
        this.separatorColor = this.parseColor(config.getString("colors.separator", "gray"));
    }

    private TextColor parseColor(String colorString) {
        if (colorString.startsWith("#")) {
            return TextColor.fromHexString((String)colorString);
        }
        return switch (colorString.toLowerCase()) {
            case "black" -> NamedTextColor.BLACK;
            case "dark_blue" -> NamedTextColor.DARK_BLUE;
            case "dark_green" -> NamedTextColor.DARK_GREEN;
            case "dark_aqua" -> NamedTextColor.DARK_AQUA;
            case "dark_red" -> NamedTextColor.DARK_RED;
            case "dark_purple" -> NamedTextColor.DARK_PURPLE;
            case "gold" -> NamedTextColor.GOLD;
            case "gray" -> NamedTextColor.GRAY;
            case "dark_gray" -> NamedTextColor.DARK_GRAY;
            case "blue" -> NamedTextColor.BLUE;
            case "green" -> NamedTextColor.GREEN;
            case "aqua" -> NamedTextColor.AQUA;
            case "red" -> NamedTextColor.RED;
            case "light_purple" -> NamedTextColor.LIGHT_PURPLE;
            case "yellow" -> NamedTextColor.YELLOW;
            default -> NamedTextColor.WHITE;
        };
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("start")) {
            return this.handleStartCommand(sender);
        }
        if (command.getName().equalsIgnoreCase("pause")) {
            return this.handlePauseCommand(sender);
        }
        if (command.getName().equalsIgnoreCase("reset")) {
            return this.handleResetCommand(sender);
        }
        return false;
    }

    private boolean handleStartCommand(CommandSender sender) {
        if (this.individualTimers) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Component.text((String)"This command can only be used by players when individual timers are enabled!").color((TextColor)NamedTextColor.RED));
                return true;
            }
            return this.handleIndividualStart((Player)sender);
        }
        return this.handleGlobalStart(sender);
    }

    private boolean handleGlobalStart(CommandSender sender) {
        if (this.globalIsRunning && !this.globalIsPaused) {
            sender.sendMessage(Component.text((String)"The timer is already running!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (this.globalIsPaused) {
            this.globalPausedDuration = this.globalPausedDuration.plus(Duration.between(this.globalPauseStartTime, Instant.now()));
            this.globalIsPaused = false;
            this.globalPauseStartTime = null;
            Bukkit.broadcast((Component)Component.text((String)"Challenge Timer resumed!").color((TextColor)NamedTextColor.GREEN));
        } else {
            this.globalStartTime = Instant.now();
            this.globalIsRunning = true;
            this.globalPausedDuration = Duration.ZERO;
            Bukkit.broadcast((Component)Component.text((String)"Challenge Timer started!").color((TextColor)NamedTextColor.GREEN));
        }
        this.startTimerTask();
        this.saveTimerData();
        return true;
    }

    private boolean handleIndividualStart(Player player) {
        UUID playerId = player.getUniqueId();
        boolean isRunning = this.playerIsRunning.getOrDefault(playerId, false);
        boolean isPaused = this.playerIsPaused.getOrDefault(playerId, false);
        if (isRunning && !isPaused) {
            player.sendMessage(Component.text((String)"Your timer is already running!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (isPaused) {
            Duration currentPaused = this.playerPausedDurations.getOrDefault(playerId, Duration.ZERO);
            Instant pauseStart = this.playerPauseStartTimes.get(playerId);
            if (pauseStart != null) {
                this.playerPausedDurations.put(playerId, currentPaused.plus(Duration.between(pauseStart, Instant.now())));
            }
            this.playerIsPaused.put(playerId, false);
            this.playerPauseStartTimes.remove(playerId);
            player.sendMessage(Component.text((String)"Your timer resumed!").color((TextColor)NamedTextColor.GREEN));
        } else {
            this.playerStartTimes.put(playerId, Instant.now());
            this.playerIsRunning.put(playerId, true);
            this.playerPausedDurations.put(playerId, Duration.ZERO);
            player.sendMessage(Component.text((String)"Your timer started!").color((TextColor)NamedTextColor.GREEN));
        }
        this.startTimerTask();
        this.saveTimerData();
        return true;
    }

    private boolean handlePauseCommand(CommandSender sender) {
        if (this.individualTimers) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Component.text((String)"This command can only be used by players when individual timers are enabled!").color((TextColor)NamedTextColor.RED));
                return true;
            }
            return this.handleIndividualPause((Player)sender);
        }
        return this.handleGlobalPause(sender);
    }

    private boolean handleGlobalPause(CommandSender sender) {
        if (!this.globalIsRunning) {
            sender.sendMessage(Component.text((String)"The timer is not running!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (this.globalIsPaused) {
            sender.sendMessage(Component.text((String)"The timer is already paused!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        this.globalIsPaused = true;
        this.globalPauseStartTime = Instant.now();
        Bukkit.broadcast((Component)Component.text((String)"Challenge Timer paused!").color((TextColor)NamedTextColor.YELLOW));
        this.saveTimerData();
        return true;
    }

    private boolean handleIndividualPause(Player player) {
        UUID playerId = player.getUniqueId();
        boolean isRunning = this.playerIsRunning.getOrDefault(playerId, false);
        boolean isPaused = this.playerIsPaused.getOrDefault(playerId, false);
        if (!isRunning) {
            player.sendMessage(Component.text((String)"Your timer is not running!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (isPaused) {
            player.sendMessage(Component.text((String)"Your timer is already paused!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        this.playerIsPaused.put(playerId, true);
        this.playerPauseStartTimes.put(playerId, Instant.now());
        player.sendMessage(Component.text((String)"Your timer paused!").color((TextColor)NamedTextColor.YELLOW));
        this.saveTimerData();
        return true;
    }

    private boolean handleResetCommand(CommandSender sender) {
        if (this.individualTimers) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Component.text((String)"This command can only be used by players when individual timers are enabled!").color((TextColor)NamedTextColor.RED));
                return true;
            }
            return this.handleIndividualReset((Player)sender);
        }
        return this.handleGlobalReset(sender);
    }

    private boolean handleGlobalReset(CommandSender sender) {
        this.globalIsRunning = false;
        this.globalIsPaused = false;
        this.globalStartTime = null;
        this.globalPausedDuration = Duration.ZERO;
        this.globalPauseStartTime = null;
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendActionBar((Component)Component.empty());
        }
        Bukkit.broadcast((Component)Component.text((String)"Challenge Timer reset!").color((TextColor)NamedTextColor.RED));
        this.saveTimerData();
        return true;
    }

    private boolean handleIndividualReset(Player player) {
        UUID playerId = player.getUniqueId();
        this.playerIsRunning.remove(playerId);
        this.playerIsPaused.remove(playerId);
        this.playerStartTimes.remove(playerId);
        this.playerPausedDurations.remove(playerId);
        this.playerPauseStartTimes.remove(playerId);
        player.sendActionBar((Component)Component.empty());
        player.sendMessage(Component.text((String)"Your timer reset!").color((TextColor)NamedTextColor.RED));
        if (!this.shouldShowTimer() && this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.saveTimerData();
        return true;
    }

    private boolean shouldShowTimer() {
        if (!this.individualTimers) {
            return this.globalIsRunning || this.globalIsPaused;
        }
        return this.playerIsRunning.values().stream().anyMatch(running -> running) || this.playerIsPaused.values().stream().anyMatch(paused -> paused);
    }

    private void startTimerTask() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = new BukkitRunnable(){

            public void run() {
                ChallengeTimer.this.updateActionBar();
            }
        };
        this.timerTask.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void updateActionBar() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Component message = this.getTimerMessage(player);
            if (message == null) continue;
            player.sendActionBar(message);
        }
    }

    private Component getTimerMessage(Player player) {
        Instant pauseStartTime;
        Duration pausedDuration;
        boolean isPaused;
        boolean isRunning;
        Instant startTime;
        if (this.individualTimers) {
            UUID playerId = player.getUniqueId();
            startTime = this.playerStartTimes.get(playerId);
            isRunning = this.playerIsRunning.getOrDefault(playerId, false);
            isPaused = this.playerIsPaused.getOrDefault(playerId, false);
            pausedDuration = this.playerPausedDurations.getOrDefault(playerId, Duration.ZERO);
            pauseStartTime = this.playerPauseStartTimes.get(playerId);
        } else {
            startTime = this.globalStartTime;
            isRunning = this.globalIsRunning;
            isPaused = this.globalIsPaused;
            pausedDuration = this.globalPausedDuration;
            pauseStartTime = this.globalPauseStartTime;
        }
        if (!isRunning && !isPaused) {
            return null;
        }
        if (startTime == null) {
            return null;
        }
        Duration totalDuration = Duration.between(startTime, Instant.now()).minus(pausedDuration);
        if (isPaused && pauseStartTime != null) {
            totalDuration = Duration.between(startTime, pauseStartTime).minus(pausedDuration);
        }
        long days = totalDuration.toDays();
        long hours = totalDuration.toHours() % 24L;
        long minutes = totalDuration.toMinutes() % 60L;
        long seconds = totalDuration.getSeconds() % 60L;
        TextComponent.Builder messageBuilder = (TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)this.timerLabel).color(this.timerTitleColor))).append(Component.text((String)this.timerDivider).color(this.separatorColor));
        if (isPaused) {
            messageBuilder.append(Component.text((String)this.stopLabel).color(this.stopLabelColor));
        } else {
            messageBuilder.append(Component.text((String)this.startLabel).color(this.startLabelColor));
        }
        if (days > 0L) {
            ((TextComponent.Builder)messageBuilder.append(Component.text((long)days).color(this.daysColor))).append(Component.text((String)"d ").color(this.separatorColor));
        }
        if (hours > 0L || days > 0L) {
            ((TextComponent.Builder)messageBuilder.append(Component.text((String)String.format("%02d", hours)).color(this.hoursColor))).append(Component.text((String)"h ").color(this.separatorColor));
        }
        ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)messageBuilder.append(Component.text((String)String.format("%02d", minutes)).color(this.minutesColor))).append(Component.text((String)"m ").color(this.separatorColor))).append(Component.text((String)String.format("%02d", seconds)).color(this.secondsColor))).append(Component.text((String)"s").color(this.separatorColor));
        return messageBuilder.build();
    }

    public void sendTimerToPlayer(Player player) {
        Component message;
        if (this.shouldShowTimer() && (message = this.getTimerMessage(player)) != null) {
            player.sendActionBar(message);
        }
    }

    public void pauseTimerForLeave(Player player) {
        if (this.individualTimers) {
            UUID playerId = player.getUniqueId();
            if (this.playerIsRunning.getOrDefault(playerId, false).booleanValue() && !this.playerIsPaused.getOrDefault(playerId, false).booleanValue()) {
                this.playerIsPaused.put(playerId, true);
                this.playerPauseStartTimes.put(playerId, Instant.now());
                player.sendMessage(Component.text((String)"Your timer was automatically paused!").color((TextColor)NamedTextColor.YELLOW));
                this.saveTimerData();
            }
        } else if (Bukkit.getOnlinePlayers().size() <= 1 && this.globalIsRunning && !this.globalIsPaused) {
            this.globalIsPaused = true;
            this.globalPauseStartTime = Instant.now();
            Bukkit.broadcast((Component)Component.text((String)"Challenge Timer automatically paused (last player left)!").color((TextColor)NamedTextColor.YELLOW));
            this.saveTimerData();
        }
    }

    public boolean isIndividualTimers() {
        return this.individualTimers;
    }
}

