/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord;

import de.gamingkaetzchen.synccord.commands.DcFindCommand;
import de.gamingkaetzchen.synccord.commands.UnlinkDiscordCommand;
import de.gamingkaetzchen.synccord.database.DatabaseManager;
import de.gamingkaetzchen.synccord.discord.DiscordBot;
import de.gamingkaetzchen.synccord.discord.InfoUpdaterOffline;
import de.gamingkaetzchen.synccord.listener.RoleSyncJoinListener;
import de.gamingkaetzchen.synccord.listener.TicketJoinAlertListener;
import de.gamingkaetzchen.synccord.shaded.bstats.bukkit.Metrics;
import de.gamingkaetzchen.synccord.tickets.TicketManager;
import de.gamingkaetzchen.synccord.util.Lang;
import java.io.File;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Synccord
extends JavaPlugin {
    private static Synccord instance;
    private DiscordBot discordBot;
    private LuckPerms luckPerms;
    private boolean debug;
    private TicketManager ticketManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.debug = this.getConfig().getBoolean("debug", false);
        Lang.init();
        Metrics metrics = new Metrics(this, 26581);
        DatabaseManager.init();
        this.ticketManager = new TicketManager(this);
        this.getCommand("unlinkdiscord").setExecutor((CommandExecutor)new UnlinkDiscordCommand());
        this.getCommand("dcfind").setExecutor((CommandExecutor)new DcFindCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new TicketJoinAlertListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new RoleSyncJoinListener(), (Plugin)this);
        File ruleFile = new File(this.getDataFolder(), "rules.yml");
        if (!ruleFile.exists()) {
            this.saveResource("rules.yml", false);
        }
        try {
            this.luckPerms = LuckPermsProvider.get();
        }
        catch (IllegalStateException e) {
            this.getLogger().warning("\u26a0 LuckPerms nicht verf\u00fcgbar!");
        }
        try {
            this.discordBot = new DiscordBot(this.getConfig().getString("discord.token"), this.ticketManager);
        }
        catch (Exception e) {
            this.getLogger().severe("\u274c Fehler beim Starten des Discord-Bots:");
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        InfoUpdaterOffline.sendOfflineEmbedSync();
        if (this.discordBot != null) {
            this.discordBot.shutdown();
        }
    }

    public static Synccord getInstance() {
        return instance;
    }

    public DiscordBot getDiscordBot() {
        return this.discordBot;
    }

    public LuckPerms getLuckPerms() {
        return this.luckPerms;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public static void debug(String message) {
        if (Synccord.getInstance().isDebug()) {
            Synccord.getInstance().getLogger().info("\u00a78[\u00a73Debug\u00a78] \u00a77" + message);
        }
    }

    public TicketManager getTicketManager() {
        return this.ticketManager;
    }
}

