/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord.commands;

import de.gamingkaetzchen.synccord.Synccord;
import de.gamingkaetzchen.synccord.database.DatabaseManager;
import de.gamingkaetzchen.synccord.discord.LinkManager;
import de.gamingkaetzchen.synccord.util.Lang;
import java.util.Optional;
import java.util.UUID;
import net.dv8tion.jda.api.JDA;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class DcFindCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (!sender.hasPermission("synccord.admin")) {
            sender.sendMessage(Lang.get("no_permission"));
            return true;
        }
        if (args2.length != 1) {
            sender.sendMessage(Lang.get("dcfind_usage"));
            return true;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)args2[0]);
        UUID uuid = player.getUniqueId();
        this.debugLog(Lang.get("debug_dcfind_start").replace("%name%", args2[0]).replace("%uuid%", uuid.toString()));
        if (!DatabaseManager.isLinked(uuid)) {
            sender.sendMessage(Lang.get("dcfind_not_found").replace("%name%", args2[0]));
            return true;
        }
        Optional<String> discordIdOpt = LinkManager.getDiscordId(uuid);
        if (discordIdOpt.isEmpty()) {
            this.debugLog(Lang.get("debug_dcfind_noid").replace("%uuid%", uuid.toString()));
            sender.sendMessage(Lang.get("dcfind_not_found").replace("%name%", args2[0]));
            return true;
        }
        String discordId = discordIdOpt.get();
        this.debugLog(Lang.get("debug_dcfind_foundid").replace("%id%", discordId));
        JDA jda = Synccord.getInstance().getDiscordBot().getJDA();
        jda.retrieveUserById(discordId).queue(user -> {
            sender.sendMessage(Lang.get("dcfind_success").replace("%name%", player.getName() != null ? player.getName() : "???").replace("%id%", discordId).replace("%tag%", user.getAsTag()));
            this.debugLog(Lang.get("debug_dcfind_tag").replace("%tag%", user.getAsTag()));
        }, error -> sender.sendMessage(Lang.get("dcfind_user_unknown").replace("%id%", discordId)));
        return true;
    }

    private void debugLog(String msg) {
        if (Synccord.getInstance().getConfig().getBoolean("debug", false)) {
            Bukkit.getLogger().info("\ud83e\udeb2 DEBUG | " + msg);
        }
    }
}

