/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord.discord;

import de.gamingkaetzchen.synccord.Synccord;
import de.gamingkaetzchen.synccord.discord.InfoButtonListener;
import de.gamingkaetzchen.synccord.discord.InfoUpdater;
import de.gamingkaetzchen.synccord.discord.LinkHandler;
import de.gamingkaetzchen.synccord.discord.commands.EmbitCommand;
import de.gamingkaetzchen.synccord.discord.commands.LinkMCCommand;
import de.gamingkaetzchen.synccord.discord.commands.SetupCommand;
import de.gamingkaetzchen.synccord.discord.commands.TicketSetupCommand;
import de.gamingkaetzchen.synccord.discord.commands.UnlinkMCCommand;
import de.gamingkaetzchen.synccord.discord.listener.EmbitListener;
import de.gamingkaetzchen.synccord.discord.listener.RuleAcceptListener;
import de.gamingkaetzchen.synccord.discord.listener.TicketButtonListener;
import de.gamingkaetzchen.synccord.tickets.TicketManager;
import de.gamingkaetzchen.synccord.util.Lang;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.requests.GatewayIntent;

public class DiscordBot {
    private final JDA jda;
    private final TicketManager ticketManager;

    public DiscordBot(String token, TicketManager ticketManager) throws Exception {
        this.ticketManager = ticketManager;
        this.debug("debug_discord_starting");
        JDABuilder builder = JDABuilder.createDefault(token).enableIntents(GatewayIntent.GUILD_MESSAGES, GatewayIntent.GUILD_MEMBERS, GatewayIntent.MESSAGE_CONTENT);
        this.jda = builder.build();
        this.jda.awaitReady();
        this.jda.addEventListener(new EmbitCommand(), new EmbitListener(), new RuleAcceptListener(), new SetupCommand(), new LinkHandler(), new InfoButtonListener(), new LinkMCCommand(), new UnlinkMCCommand(), new TicketButtonListener(ticketManager), new TicketSetupCommand(ticketManager, this.jda));
        this.debug("debug_discord_ready");
        this.registerCommands();
        InfoUpdater.recoverOrOffline(this.jda);
    }

    private void registerCommands() {
        this.debug("debug_registering_slash_commands");
        this.jda.updateCommands().addCommands(Commands.slash("setup", Lang.get("setup_description")).addOption(OptionType.STRING, "type", Lang.get("setup_option_type_description"), true, true), Commands.slash("linkmc", Lang.get("linkmc_description")).addOption(OptionType.STRING, "uuid", Lang.get("linkmc_option_uuid"), true).addOption(OptionType.STRING, "discordid", Lang.get("linkmc_option_discordid"), true), Commands.slash("unlinkmc", Lang.get("unlinkmc_description")).addOption(OptionType.STRING, "uuid", Lang.get("unlinkmc_option_uuid"), true), Commands.slash("ticket", "Ticket-System verwalten").addSubcommands(new SubcommandData("setup", "Ticket-Buttons posten").addOption(OptionType.STRING, "type", "Tickettyp-ID aus config.yml", true, true).addOption(OptionType.CHANNEL, "channel", "Channel, in dem der Button gepostet werden soll", true)), EmbitCommand.getCommandData()).queue();
    }

    public void shutdown() {
        if (this.jda != null) {
            this.debug("debug_discord_shutdown");
            this.jda.shutdown();
        }
    }

    public JDA getJDA() {
        return this.jda;
    }

    public TicketManager getTicketManager() {
        return this.ticketManager;
    }

    private boolean isDebug() {
        return Synccord.getInstance().getConfig().getBoolean("debug", false);
    }

    private void debug(String key) {
        if (this.isDebug()) {
            Synccord.getInstance().getLogger().info(Lang.get(key));
        }
    }
}

