/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord.discord;

import de.gamingkaetzchen.synccord.Synccord;
import de.gamingkaetzchen.synccord.util.Lang;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InfoUpdater {
    private static Message lastMessage;
    private static String lastChannelId;
    private static String lastMessageId;
    private static BukkitRunnable task;
    private static final String STATE_FILE = "status-message.yml";

    public static void startAutoUpdate(MessageChannel channel, Message message) {
        InfoUpdater.debug("debug_info_starting_autoupdate");
        lastMessage = message;
        lastChannelId = channel.getId();
        lastMessageId = message.getId();
        InfoUpdater.saveState();
        InfoUpdater.startTask();
    }

    public static void recoverOrOffline(JDA jda) {
        InfoUpdater.debug("debug_info_try_recover");
        InfoUpdater.loadState();
        if (lastChannelId == null || lastMessageId == null) {
            InfoUpdater.debug("debug_info_no_state_found");
            return;
        }
        MessageChannel channel = jda.getChannelById(MessageChannel.class, lastChannelId);
        if (channel == null) {
            InfoUpdater.debug("debug_info_channel_not_found");
            return;
        }
        channel.retrieveMessageById(lastMessageId).queue(msg -> {
            InfoUpdater.debug("debug_info_message_found");
            lastMessage = msg;
            InfoUpdater.startTask();
        }, failure -> {
            InfoUpdater.debug("debug_info_message_not_found_creating_new");
            EmbedBuilder embed = InfoUpdater.buildStatusEmbed(Synccord.getInstance().getDiscordBot().getJDA().getSelfUser().getAvatarUrl());
            ((MessageCreateAction)channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).setActionRow(Button.primary("show_players", "\ud83d\udd0d " + Lang.get("show_players_button")))).queue(sentMsg -> {
                InfoUpdater.debug("debug_info_message_sent");
                InfoUpdater.startAutoUpdate(channel, sentMsg);
            });
        });
    }

    private static void startTask() {
        if (task != null) {
            task.cancel();
        }
        int interval = Synccord.getInstance().getConfig().getInt("tps-monitor.update-interval", 60);
        InfoUpdater.debug("debug_info_update_interval", "%interval%", String.valueOf(interval));
        task = new BukkitRunnable(){

            public void run() {
                if (!Synccord.getInstance().getConfig().getBoolean("tps-monitor.auto-update", true)) {
                    InfoUpdater.debug("debug_info_autoupdate_disabled");
                    this.cancel();
                    return;
                }
                if (lastMessage == null) {
                    InfoUpdater.debug("debug_info_message_missing");
                    this.cancel();
                    return;
                }
                try {
                    String iconUrl = Synccord.getInstance().getDiscordBot().getJDA().getSelfUser().getAvatarUrl();
                    EmbedBuilder embed = InfoUpdater.buildStatusEmbed(iconUrl);
                    ((MessageEditAction)lastMessage.editMessageEmbeds(embed.build()).setActionRow(Button.primary("show_players", "\ud83d\udd0d " + Lang.get("show_players_button")))).queue(success -> InfoUpdater.debug("debug_info_embed_updated"), error -> {
                        Bukkit.getLogger().warning(Lang.get("info_embed_error"));
                        InfoUpdater.debug("debug_info_embed_update_error", "%error%", error.getMessage());
                    });
                }
                catch (Exception e) {
                    Bukkit.getLogger().warning(Lang.get("debug_info_embed_update_exception"));
                    e.printStackTrace();
                }
            }
        };
        task.runTaskTimerAsynchronously((Plugin)Synccord.getInstance(), (long)interval * 20L, (long)interval * 20L);
    }

    public static EmbedBuilder buildStatusEmbed(String iconUrl) {
        String javaIp = Synccord.getInstance().getConfig().getString("discord.java-ip", "???");
        String bedrockIp = Synccord.getInstance().getConfig().getString("discord.bedrock-ip", "???");
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        double[] tps = Bukkit.getServer().getTPS();
        double mspt = Bukkit.getServer().getAverageTickTime();
        String version = Bukkit.getServer().getName() + " " + Bukkit.getMinecraftVersion();
        return new EmbedBuilder().setTitle(Lang.get("info_embed_title")).setDescription(" ").addField(Lang.get("info_embed_field_java"), javaIp, true).addField(Lang.get("info_embed_field_bedrock"), bedrockIp, true).addField(Lang.get("info_embed_field_players"), String.valueOf(onlinePlayers), true).addField(Lang.get("info_embed_field_tps"), String.format("%.2f", tps[0]), true).addField(Lang.get("info_embed_field_mspt"), String.format("%.2f", mspt), true).addField(Lang.get("info_embed_field_version"), version, true).setThumbnail(iconUrl).setFooter(Lang.get("info_embed_footer"), iconUrl).setTimestamp(Instant.now()).setColor(Color.CYAN);
    }

    private static void saveState() {
        File file = new File(Synccord.getInstance().getDataFolder(), STATE_FILE);
        YamlConfiguration cfg = new YamlConfiguration();
        cfg.set("channel-id", (Object)lastChannelId);
        cfg.set("message-id", (Object)lastMessageId);
        try {
            cfg.save(file);
            InfoUpdater.debug("debug_info_state_saved");
        }
        catch (IOException e) {
            Synccord.getInstance().getLogger().warning(Lang.get("debug_info_state_save_failed"));
        }
    }

    private static void loadState() {
        File file = new File(Synccord.getInstance().getDataFolder(), STATE_FILE);
        if (!file.exists()) {
            return;
        }
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        lastChannelId = cfg.getString("channel-id");
        lastMessageId = cfg.getString("message-id");
    }

    private static void debug(String key) {
        if (Synccord.getInstance().getConfig().getBoolean("debug", false)) {
            Synccord.getInstance().getLogger().info(Lang.get(key));
        }
    }

    private static void debug(String key, String placeholder, String value) {
        if (Synccord.getInstance().getConfig().getBoolean("debug", false)) {
            Synccord.getInstance().getLogger().info(Lang.get(key).replace(placeholder, value));
        }
    }

    public static String getLastChannelId() {
        return lastChannelId;
    }

    public static String getLastMessageId() {
        return lastMessageId;
    }
}

