/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord.discord.commands;

import de.gamingkaetzchen.synccord.Synccord;
import de.gamingkaetzchen.synccord.discord.LinkManager;
import de.gamingkaetzchen.synccord.util.Lang;
import java.util.UUID;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;

public class LinkMCCommand
extends ListenerAdapter {
    @Override
    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        block8: {
            if (!event.getName().equalsIgnoreCase("linkmc")) {
                return;
            }
            if (event.getMember() == null || !event.getMember().hasPermission(Permission.ADMINISTRATOR)) {
                event.reply(Lang.get("linkmc_no_permission")).setEphemeral(true).queue();
                return;
            }
            OptionMapping uuidOption = event.getOption("uuid");
            OptionMapping discordOption = event.getOption("discordid");
            if (uuidOption == null || discordOption == null) {
                event.reply(Lang.get("linkmc_missing_args")).setEphemeral(true).queue();
                return;
            }
            String uuidStr = uuidOption.getAsString();
            String discordId = discordOption.getAsString();
            if (this.isDebug()) {
                Synccord.getInstance().getLogger().info(Lang.get("debug_linkmc_received").replace("%uuid%", uuidStr).replace("%discord%", discordId));
            }
            try {
                UUID uuid = UUID.fromString(uuidStr);
                if (!discordId.matches("\\d{17,20}")) {
                    event.reply(Lang.get("linkmc_invalid_discordid")).setEphemeral(true).queue();
                    return;
                }
                LinkManager.link(uuid, discordId);
                if (this.isDebug()) {
                    Synccord.getInstance().getLogger().info(Lang.get("debug_linkmc_success").replace("%uuid%", uuidStr).replace("%discord%", discordId));
                }
                event.reply(Lang.get("linkmc_success").replace("%uuid%", uuidStr).replace("%discord%", discordId)).setEphemeral(true).queue();
            }
            catch (IllegalArgumentException e) {
                event.reply(Lang.get("linkmc_invalid_uuid")).setEphemeral(true).queue();
                if (!this.isDebug()) break block8;
                Synccord.getInstance().getLogger().warning(Lang.get("debug_linkmc_invalid_uuid").replace("%uuid%", uuidStr));
            }
        }
    }

    private boolean isDebug() {
        return Synccord.getInstance().getConfig().getBoolean("debug", false);
    }
}

