/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord.discord.commands;

import de.gamingkaetzchen.synccord.Synccord;
import de.gamingkaetzchen.synccord.discord.InfoUpdater;
import de.gamingkaetzchen.synccord.util.Lang;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import org.bukkit.configuration.file.YamlConfiguration;

public class SetupCommand
extends ListenerAdapter {
    @Override
    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        String guildIconUrl;
        if (!event.getName().equals("setup")) {
            return;
        }
        Member member = event.getMember();
        if (member == null || !member.hasPermission(Permission.ADMINISTRATOR)) {
            event.reply(Lang.get("no_permission")).setEphemeral(true).queue();
            return;
        }
        OptionMapping option = event.getOption("type");
        if (option == null) {
            event.reply(Lang.get("invalid_type")).setEphemeral(true).queue();
            return;
        }
        String type = option.getAsString();
        String string = guildIconUrl = event.getGuild() != null ? event.getGuild().getIconUrl() : null;
        if (this.isDebug()) {
            Synccord.getInstance().getLogger().info(Lang.get("debug_setup_used").replace("%type%", type));
        }
        if (type.equalsIgnoreCase("linking")) {
            EmbedBuilder embed = new EmbedBuilder().setTitle(Lang.get("link_embed_title")).setDescription(Lang.get("link_embed_description")).setColor(Color.GREEN).setThumbnail(guildIconUrl).setFooter(Lang.get("footer_text"), guildIconUrl);
            ((ReplyCallbackAction)event.replyEmbeds(embed.build(), new MessageEmbed[0]).addActionRow(Button.primary("link_code", Lang.get("link_button")))).queue();
            if (this.isDebug()) {
                Synccord.getInstance().getLogger().info(Lang.get("debug_setup_linking_sent"));
            }
        } else if (type.equalsIgnoreCase("info")) {
            EmbedBuilder embed = InfoUpdater.buildStatusEmbed(guildIconUrl);
            MessageChannelUnion channel = event.getChannel();
            ((MessageCreateAction)channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).addActionRow(Button.primary("show_players", "\ud83d\udd0d " + Lang.get("show_players_button")))).submit().thenAccept(msg -> {
                InfoUpdater.startAutoUpdate(channel, msg);
                if (this.isDebug()) {
                    Synccord.getInstance().getLogger().info(Lang.get("debug_setup_info_started"));
                }
            });
            event.reply(Lang.get("info_sent")).setEphemeral(true).queue();
        } else if (type.equalsIgnoreCase("regel")) {
            File ruleFile = new File(Synccord.getInstance().getDataFolder(), "rules.yml");
            YamlConfiguration rulesConfig = YamlConfiguration.loadConfiguration((File)ruleFile);
            ArrayList<MessageEmbed> embeds = new ArrayList<MessageEmbed>();
            if (!rulesConfig.contains("regeln") || rulesConfig.getConfigurationSection("regeln") == null) {
                event.reply("\u274c rules.yml ung\u00fcltig oder leer.").setEphemeral(true).queue();
                return;
            }
            for (String section : rulesConfig.getConfigurationSection("regeln").getKeys(false)) {
                List regeln = rulesConfig.getStringList("regeln." + section);
                StringBuilder sb = new StringBuilder();
                for (String regel : regeln) {
                    sb.append("\u2022 ").append(regel).append("\n\n");
                }
                EmbedBuilder embed = new EmbedBuilder().setTitle("\ud83d\udcdc " + section.replace("_", " ")).setDescription(sb.toString().trim()).setColor(Color.ORANGE).setThumbnail(guildIconUrl).setFooter(Lang.get("footer_text"), guildIconUrl);
                embeds.add(embed.build());
            }
            event.deferReply().queue(hook -> {
                MessageChannelUnion channel = event.getChannel();
                if (channel == null) {
                    hook.sendMessage("\u274c Fehler: Kein Channel verf\u00fcgbar.").setEphemeral(true).queue();
                    return;
                }
                if (!embeds.isEmpty()) {
                    for (int i = 0; i < embeds.size() - 1; ++i) {
                        channel.sendMessageEmbeds((MessageEmbed)embeds.get(i), new MessageEmbed[0]).queue();
                    }
                    ((MessageCreateAction)channel.sendMessageEmbeds((MessageEmbed)embeds.get(embeds.size() - 1), new MessageEmbed[0]).addActionRow(Button.success("rule_accept_button", Lang.get("setup_rule_button")))).queue();
                }
                hook.sendMessage(Lang.get("setup_rule_sent")).setEphemeral(true).queue();
            });
            if (this.isDebug()) {
                Synccord.getInstance().getLogger().info(Lang.get("debug_setup_regel_sent"));
            }
        } else {
            event.reply(Lang.get("invalid_type")).setEphemeral(true).queue();
        }
    }

    @Override
    public void onCommandAutoCompleteInteraction(CommandAutoCompleteInteractionEvent event) {
        if (!event.getName().equals("setup") || !event.getFocusedOption().getName().equals("type")) {
            return;
        }
        List<Command.Choice> choices = List.of(new Command.Choice("linking", "linking"), new Command.Choice("info", "info"), new Command.Choice("regel", "regel"));
        event.replyChoices(choices).queue();
        if (this.isDebug()) {
            Synccord.getInstance().getLogger().info(Lang.get("debug_setup_autocomplete"));
        }
    }

    private boolean isDebug() {
        return Synccord.getInstance().getConfig().getBoolean("debug", false);
    }
}

