/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord.discord.commands;

import de.gamingkaetzchen.synccord.Synccord;
import de.gamingkaetzchen.synccord.database.DatabaseManager;
import de.gamingkaetzchen.synccord.util.Lang;
import java.util.UUID;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;

public class UnlinkMCCommand
extends ListenerAdapter {
    @Override
    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        if (!event.getName().equalsIgnoreCase("unlinkmc")) {
            return;
        }
        if (event.getMember() == null || !event.getMember().hasPermission(Permission.ADMINISTRATOR)) {
            event.reply(Lang.get("no_permission")).setEphemeral(true).queue();
            return;
        }
        OptionMapping uuidOption = event.getOption("uuid");
        if (uuidOption == null) {
            event.reply(Lang.get("unlinkmc_missing_uuid")).setEphemeral(true).queue();
            return;
        }
        String uuidStr = uuidOption.getAsString();
        try {
            UUID uuid = UUID.fromString(uuidStr);
            if (!DatabaseManager.isLinked(uuid)) {
                if (this.isDebug()) {
                    Synccord.getInstance().getLogger().info(Lang.get("debug_unlinkmc_not_linked").replace("%uuid%", uuidStr));
                }
                event.reply(Lang.get("unlinkmc_not_linked").replace("%uuid%", uuidStr)).setEphemeral(true).queue();
                return;
            }
            DatabaseManager.unlink(uuid);
            if (this.isDebug()) {
                Synccord.getInstance().getLogger().info(Lang.get("debug_unlinkmc_success").replace("%uuid%", uuid.toString()));
            }
            event.reply(Lang.get("unlinkmc_success").replace("%uuid%", uuid.toString())).setEphemeral(true).queue();
        }
        catch (IllegalArgumentException e) {
            if (this.isDebug()) {
                Synccord.getInstance().getLogger().warning(Lang.get("debug_unlinkmc_invalid_uuid").replace("%uuid%", uuidStr));
            }
            event.reply(Lang.get("unlinkmc_invalid_uuid")).setEphemeral(true).queue();
        }
    }

    private boolean isDebug() {
        return Synccord.getInstance().getConfig().getBoolean("debug", false);
    }
}

