/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord.discord.listener;

import de.gamingkaetzchen.synccord.Synccord;
import de.gamingkaetzchen.synccord.util.Lang;
import java.awt.Color;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;

public class EmbitListener
extends ListenerAdapter {
    @Override
    public void onModalInteraction(ModalInteractionEvent event) {
        block10: {
            Color color;
            String colorHex;
            String footer;
            String image;
            String content;
            String title;
            block9: {
                if (!event.getModalId().equals("embit_modal")) {
                    return;
                }
                title = event.getValue("title") != null ? event.getValue("title").getAsString().trim() : "";
                content = event.getValue("content") != null ? event.getValue("content").getAsString().trim() : "";
                image = event.getValue("image") != null ? event.getValue("image").getAsString().trim() : "";
                footer = event.getValue("footer") != null ? event.getValue("footer").getAsString().trim() : "";
                String colorInput = event.getValue("color") != null ? event.getValue("color").getAsString().trim() : "";
                colorHex = colorInput.isEmpty() ? "#2ECC71" : colorInput;
                try {
                    color = Color.decode(colorHex);
                }
                catch (NumberFormatException e) {
                    color = Color.decode("#2ECC71");
                    if (!Synccord.getInstance().isDebug()) break block9;
                    Synccord.getInstance().getLogger().warning("[Debug] Ung\u00fcltiger Hexcode '" + colorHex + "', Standardfarbe wird verwendet.");
                }
            }
            if (Synccord.getInstance().isDebug()) {
                Synccord.getInstance().getLogger().info(Lang.get("debug_embit_submitted").replace("%title%", title).replace("%content%", content).replace("%image%", image).replace("%footer%", footer).replace("%color%", colorHex));
            }
            try {
                EmbedBuilder embed = new EmbedBuilder().setTitle(title).setDescription(content).setColor(color);
                if (!image.isEmpty()) {
                    embed.setImage(image);
                }
                if (!footer.isEmpty()) {
                    embed.setFooter(footer);
                }
                event.replyEmbeds(embed.build(), new MessageEmbed[0]).queue();
                if (Synccord.getInstance().isDebug()) {
                    Synccord.getInstance().getLogger().info(Lang.get("embit_success"));
                }
            }
            catch (Exception e) {
                event.reply(Lang.get("embit_fail")).setEphemeral(true).queue();
                if (!Synccord.getInstance().isDebug()) break block10;
                e.printStackTrace();
            }
        }
    }
}

