/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord.discord.listener;

import de.gamingkaetzchen.synccord.Synccord;
import de.gamingkaetzchen.synccord.discord.listener.TicketChannelCreator;
import de.gamingkaetzchen.synccord.tickets.TicketManager;
import de.gamingkaetzchen.synccord.tickets.TicketQuestion;
import de.gamingkaetzchen.synccord.tickets.TicketType;
import de.gamingkaetzchen.synccord.util.Lang;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.EntitySelectInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.selections.EntitySelectMenu;
import net.dv8tion.jda.api.interactions.components.text.TextInput;
import net.dv8tion.jda.api.interactions.components.text.TextInputStyle;
import net.dv8tion.jda.api.interactions.modals.Modal;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import net.dv8tion.jda.api.utils.FileUpload;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class TicketButtonListener
extends ListenerAdapter {
    private final TicketManager ticketManager;
    private final TicketChannelCreator channelCreator;

    public TicketButtonListener(TicketManager ticketManager) {
        this.ticketManager = ticketManager;
        this.channelCreator = new TicketChannelCreator(ticketManager);
    }

    @Override
    public void onButtonInteraction(@NotNull ButtonInteractionEvent event) {
        String id = event.getComponentId();
        if (id.equals("ticket:add_user")) {
            EntitySelectMenu menu = ((EntitySelectMenu.Builder)((EntitySelectMenu.Builder)((EntitySelectMenu.Builder)EntitySelectMenu.create("ticket:add_user_select", EntitySelectMenu.SelectTarget.USER, new EntitySelectMenu.SelectTarget[0]).setPlaceholder("Benutzer ausw\u00e4hlen \u2026")).setMinValues(1)).setMaxValues(1)).build();
            EmbedBuilder embed = new EmbedBuilder().setColor(Color.YELLOW).setDescription(Lang.get("ticket_add_user_select")).setFooter("Ticket-System | Benutzer hinzuf\u00fcgen", event.getJDA().getSelfUser().getEffectiveAvatarUrl()).setTimestamp(Instant.now());
            ((ReplyCallbackAction)event.replyEmbeds(embed.build(), new MessageEmbed[0]).addActionRow(menu)).setEphemeral(true).queue();
            return;
        }
        if (id.equals("ticket:claim")) {
            Member claimer = event.getMember();
            if (claimer == null) {
                this.replyEmbed(event, Lang.get("ticket_no_user"), Color.RED);
                return;
            }
            MessageChannelUnion channel = event.getChannel();
            channel.getHistory().retrievePast(10).queue(messages -> {
                for (Message message : messages) {
                    if (message.getEmbeds().isEmpty()) continue;
                    MessageEmbed oldEmbed = message.getEmbeds().get(0);
                    boolean alreadyClaimed = oldEmbed.getFields().stream().anyMatch(field -> field.getName().contains("\u00dcbernommen von"));
                    if (alreadyClaimed) {
                        this.replyEmbed(event, Lang.get("ticket_already_claimed"), Color.RED);
                        return;
                    }
                    EmbedBuilder builder = new EmbedBuilder(oldEmbed).setColor(Color.ORANGE).addField("\ud83d\udd12 \u00dcbernommen von", claimer.getAsMention(), false);
                    message.editMessageEmbeds(builder.build()).queue();
                    channel.sendMessageEmbeds(new EmbedBuilder().setDescription(Lang.get("ticket_claimed_broadcast").replace("%user%", claimer.getAsMention())).setColor(Color.ORANGE).build(), new MessageEmbed[0]).queue();
                    this.replyEmbed(event, Lang.get("ticket_claimed_success"), Color.GREEN);
                    return;
                }
                this.replyEmbed(event, Lang.get("ticket_message_not_found"), Color.RED);
            });
            return;
        }
        if (id.equals("ticket:close")) {
            String channelId = event.getChannel().getId();
            EmbedBuilder embed = new EmbedBuilder().setColor(Color.RED).setDescription(Lang.get("ticket_close_confirm")).setTimestamp(Instant.now());
            ((ReplyCallbackAction)event.replyEmbeds(embed.build(), new MessageEmbed[0]).addActionRow(Button.danger("ticket:confirm_close:" + channelId, Lang.get("ticket_close_confirm_yes")), Button.secondary("ticket:cancel_close:" + channelId, Lang.get("ticket_close_confirm_no")))).setEphemeral(true).queue();
            return;
        }
        if (id.startsWith("ticket:confirm_close:")) {
            String channelId = id.split(":")[2];
            TextChannel ticketChannel = event.getJDA().getTextChannelById(channelId);
            if (ticketChannel == null) {
                this.replyEmbed(event, Lang.get("ticket_channel_not_found"), Color.RED);
                return;
            }
            File configFile = new File("tickets", channelId + ".yml");
            if (!configFile.exists()) {
                this.replyEmbed(event, Lang.get("ticket_type_not_found"), Color.RED);
                return;
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            String typeId = config.getString("ticket_id");
            TicketType type = Synccord.getInstance().getTicketManager().getTicketTypeById(typeId);
            if (typeId == null || type == null) {
                this.replyEmbed(event, Lang.get("ticket_type_not_found"), Color.RED);
                return;
            }
            String logChannelId = Synccord.getInstance().getConfig().getString("tickets." + type.getId() + ".log-channel-id");
            TextChannel logChannel = event.getGuild().getTextChannelById(logChannelId);
            event.deferReply(true).queue();
            ticketChannel.getHistory().retrievePast(100).queue(messages -> {
                StringBuilder transcript = new StringBuilder();
                for (int i = messages.size() - 1; i >= 0; --i) {
                    Message msg = (Message)messages.get(i);
                    transcript.append("[").append(msg.getTimeCreated()).append("] ").append(msg.getAuthor().getName()).append(": ").append(msg.getContentDisplay()).append("\n");
                }
                try {
                    File dir = new File("ticket", type.getId());
                    dir.mkdirs();
                    File file = new File(dir, channelId + ".txt");
                    Files.write(file.toPath(), transcript.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    if (logChannel != null) {
                        ByteArrayInputStream input = new ByteArrayInputStream(Files.readAllBytes(file.toPath()));
                        FileUpload upload = FileUpload.fromData(input, "transcript.txt");
                        EmbedBuilder embed = new EmbedBuilder().setTitle("\ud83d\udcc1 Transkript f\u00fcr Ticket").setDescription("Ticket `" + ticketChannel.getName() + "` wurde geschlossen.").setColor(Color.DARK_GRAY).setTimestamp(Instant.now());
                        ((MessageCreateAction)logChannel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).addFiles(upload)).queue();
                    }
                    Synccord.debug("[Debug] Transkript gespeichert unter: " + file.getAbsolutePath());
                }
                catch (IOException e) {
                    this.replyEmbed(event, "\u26a0 Fehler beim Speichern des Transkripts: " + e.getMessage(), Color.RED);
                    return;
                }
                ticketChannel.sendMessageEmbeds(new EmbedBuilder().setDescription(Lang.get("ticket_closing_broadcast")).setColor(Color.RED).build(), new MessageEmbed[0]).queue();
                ticketChannel.delete().queueAfter(5L, TimeUnit.SECONDS);
                event.getHook().sendMessageEmbeds(new EmbedBuilder().setDescription(Lang.get("ticket_closing_success")).setColor(Color.GREEN).build(), new MessageEmbed[0]).setEphemeral(true).queue();
            });
            return;
        }
        if (id.startsWith("ticket:send_transcript:")) {
            String channelId = id.split(":")[2];
            String logChannelId = Synccord.getInstance().getConfig().getString("tickets.log_channel_id");
            TextChannel logChannel = event.getGuild().getTextChannelById(logChannelId);
            File ticketDir = new File("ticket");
            File foundFile = null;
            if (ticketDir.exists()) {
                for (File subDir : ticketDir.listFiles()) {
                    File file = new File(subDir, channelId + ".txt");
                    if (!file.exists()) continue;
                    foundFile = file;
                    break;
                }
            }
            if (foundFile == null || logChannel == null) {
                this.replyEmbed(event, Lang.get("ticket_transcript_not_found"), Color.RED);
                return;
            }
            try {
                ByteArrayInputStream input = new ByteArrayInputStream(Files.readAllBytes(foundFile.toPath()));
                FileUpload file = FileUpload.fromData(input, "transcript.txt");
                EmbedBuilder embed = new EmbedBuilder().setTitle("\ud83d\udcc1 Transkript f\u00fcr Ticket").setDescription("Das Transkript wird in 5 Minuten gel\u00f6scht.").setColor(Color.DARK_GRAY).setTimestamp(Instant.now());
                File fileToDelete = foundFile;
                ((MessageCreateAction)logChannel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).addFiles(file)).queue(msg -> {
                    msg.delete().queueAfter(5L, TimeUnit.MINUTES);
                    fileToDelete.delete();
                });
                this.replyEmbed(event, Lang.get("ticket_transcript_sent"), Color.GREEN);
            }
            catch (IOException e) {
                this.replyEmbed(event, "\u26a0 Fehler beim Laden des Transkripts: " + e.getMessage(), Color.RED);
            }
            return;
        }
        if (id.startsWith("ticket:cancel_close:")) {
            this.replyEmbed(event, Lang.get("ticket_close_cancelled"), Color.GRAY);
            return;
        }
        String[] idParts = id.split(":");
        if (idParts.length == 2 && idParts[0].equals("ticket")) {
            String ticketId = idParts[1];
            TicketType type = this.ticketManager.getTicketTypeById(ticketId);
            if (type == null) {
                this.replyEmbed(event, Lang.get("ticket_type_not_found"), Color.RED);
                return;
            }
            Modal.Builder modal = Modal.create("ticketmodal:" + type.getId(), type.getName());
            for (Map.Entry<Integer, TicketQuestion> entry : type.getQuestions().entrySet()) {
                TicketQuestion tq = entry.getValue();
                TextInput input = TextInput.create("q" + String.valueOf(entry.getKey()), String.join((CharSequence)" ", tq.getQuestions()), TextInputStyle.PARAGRAPH).setRequired(true).setMaxLength(tq.getInputLimit()).build();
                modal.addActionRow(input);
            }
            event.replyModal(modal.build()).queue();
        }
    }

    @Override
    public void onModalInteraction(@NotNull ModalInteractionEvent event) {
        String[] idParts = event.getModalId().split(":");
        if (idParts.length != 2 || !idParts[0].equals("ticketmodal")) {
            return;
        }
        String ticketId = idParts[1];
        TicketType type = this.ticketManager.getTicketTypeById(ticketId);
        if (type == null || event.getMember() == null) {
            return;
        }
        this.channelCreator.createTicketChannel(event, event.getMember(), type);
    }

    @Override
    public void onEntitySelectInteraction(@NotNull EntitySelectInteractionEvent event) {
        if (!event.getComponentId().equals("ticket:add_user_select")) {
            return;
        }
        if (event.getMentions().getMembers().isEmpty()) {
            this.replyEmbed(event, Lang.get("ticket_user_select_none"), Color.GRAY);
            return;
        }
        Member target = event.getMentions().getMembers().get(0);
        MessageChannelUnion messageChannelUnion = event.getChannel();
        if (messageChannelUnion instanceof TextChannel) {
            TextChannel channel = (TextChannel)((Object)messageChannelUnion);
            channel.upsertPermissionOverride(target).setAllowed(Permission.VIEW_CHANNEL, Permission.MESSAGE_SEND).queue(success -> this.replyEmbed(event, Lang.get("ticket_user_added").replace("%user%", target.getAsMention()), Color.GREEN), error -> this.replyEmbed(event, Lang.get("ticket_user_add_error").replace("%error%", error.getMessage()), Color.RED));
        } else {
            this.replyEmbed(event, Lang.get("ticket_channel_no_permissions"), Color.RED);
        }
    }

    private void replyEmbed(ButtonInteractionEvent event, String message, Color color) {
        event.replyEmbeds(new EmbedBuilder().setDescription(message).setColor(color).setTimestamp(Instant.now()).build(), new MessageEmbed[0]).setEphemeral(true).queue();
    }

    private void replyEmbed(EntitySelectInteractionEvent event, String message, Color color) {
        event.replyEmbeds(new EmbedBuilder().setDescription(message).setColor(color).setTimestamp(Instant.now()).build(), new MessageEmbed[0]).setEphemeral(true).queue();
    }

    public TicketType getTypeByChannel(TextChannel channel) {
        String name = channel.getName();
        for (TicketType type : this.ticketManager.getTicketTypes()) {
            if (!name.startsWith(type.getId() + "-")) continue;
            return type;
        }
        return null;
    }

    public TicketType loadTicketTypeByChannelId(String channelId) {
        File file = new File("tickets", channelId + ".yml");
        if (!file.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String typeId = config.getString("ticket_id");
        if (typeId == null) {
            return null;
        }
        return this.ticketManager.getTicketTypeById(typeId);
    }

    private void debug(String key, String value) {
        if (Synccord.getInstance().getConfig().getBoolean("debug", false)) {
            Synccord.getInstance().getLogger().info("[Debug] " + Lang.get(key).replace("%value%", value).replace("%ticket%", value).replace("%channel%", value).replace("%role%", value));
        }
    }

    private void debug(String key) {
        if (Synccord.getInstance().getConfig().getBoolean("debug", false)) {
            Synccord.getInstance().getLogger().info("[Debug] " + Lang.get(key));
        }
    }
}

