/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord.discord.util;

import de.gamingkaetzchen.synccord.Synccord;
import de.gamingkaetzchen.synccord.util.Lang;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.SequencedCollection;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.utils.FileUpload;

public class TranskriptUtil {
    public static void createAndSendTranscript(JDA jda, MessageChannel channel, String logChannelId) {
        if (!(channel instanceof TextChannel)) {
            TranskriptUtil.debug("debug_transcript_channel_invalid");
            return;
        }
        TextChannel textChannel = (TextChannel)channel;
        textChannel.getHistory().retrievePast(100).queue(messages -> {
            StringBuilder sb = new StringBuilder();
            SequencedCollection reversed = messages.reversed();
            for (Message msg : reversed) {
                sb.append("[").append(msg.getTimeCreated()).append("] ").append(msg.getAuthor().getName()).append(": ").append(msg.getContentDisplay()).append("\n");
            }
            ByteArrayInputStream transcriptStream = new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
            TextChannel logChannel = jda.getTextChannelById(logChannelId);
            if (logChannel != null) {
                ((MessageCreateAction)logChannel.sendFiles(FileUpload.fromData(transcriptStream, "transcript.txt")).setEmbeds(new EmbedBuilder().setTitle(Lang.get("ticket_transcript_title")).setDescription(Lang.get("ticket_transcript_description")).setColor(Color.GRAY).build())).queue();
                TranskriptUtil.debug("debug_transcript_sent".replace("%channel%", logChannel.getName()));
            } else {
                TranskriptUtil.debug("debug_transcript_logchannel_not_found".replace("%id%", logChannelId));
            }
        });
    }

    private static void debug(String msg) {
        if (Synccord.getInstance().getConfig().getBoolean("debug", false)) {
            Synccord.getInstance().getLogger().info("[Debug] " + msg);
        }
    }
}

