/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord.tickets;

import de.gamingkaetzchen.synccord.tickets.TicketQuestion;
import de.gamingkaetzchen.synccord.tickets.TicketType;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TicketManager {
    private final JavaPlugin plugin;
    private final Map<String, TicketType> ticketTypes = new HashMap<String, TicketType>();
    private final Map<Long, UUID> linkedPlayers = new HashMap<Long, UUID>();

    public TicketManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadTickets();
    }

    public void loadTickets() {
        this.ticketTypes.clear();
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("tickets");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection ticketSection = section.getConfigurationSection(key);
            if (ticketSection == null) continue;
            String name = ticketSection.getString("name", "Unnamed");
            String description = ticketSection.getString("description", "");
            String buttonName = ticketSection.getString("button_name", "Create Ticket");
            String categoryId = ticketSection.getString("ticketkategorie");
            List supporterRoles = ticketSection.getStringList("supporter_roles");
            TreeMap<Integer, TicketQuestion> questions = new TreeMap<Integer, TicketQuestion>();
            ConfigurationSection questionSection = ticketSection.getConfigurationSection("question");
            if (questionSection != null) {
                for (String qKey : questionSection.getKeys(false)) {
                    try {
                        int index = Integer.parseInt(qKey);
                        int inputLimit = questionSection.getInt(qKey + ".input", 100);
                        List questionLines = questionSection.getStringList(qKey + ".questions");
                        questions.put(index, new TicketQuestion(inputLimit, questionLines));
                    }
                    catch (NumberFormatException ex) {
                        this.plugin.getLogger().warning("Ung\u00fcltiger Fragenindex in TicketTyp '" + key + "': " + qKey);
                    }
                }
            }
            TicketType ticketType = new TicketType(key, name, description, buttonName, categoryId, supporterRoles, questions);
            this.ticketTypes.put(key, ticketType);
        }
    }

    public Collection<TicketType> getAllTicketTypes() {
        return this.ticketTypes.values();
    }

    public TicketType getTicketTypeById(String id) {
        return this.ticketTypes.get(id);
    }

    public TicketType getTypeByChannel(TextChannel channel) {
        String name = channel.getName();
        for (TicketType type : this.getTicketTypes()) {
            if (!name.startsWith(type.getId() + "-")) continue;
            return type;
        }
        return null;
    }

    public TicketType getTypeByChannelId(String channelId) {
        File file = new File("tickets", channelId + ".yml");
        if (!file.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String typeId = config.getString("ticket_id");
        if (typeId == null) {
            return null;
        }
        return this.getTicketTypeById(typeId);
    }

    public Optional<Player> getOnlinePlayer(long discordId) {
        UUID uuid = this.linkedPlayers.get(discordId);
        return uuid == null ? Optional.empty() : Optional.ofNullable(Bukkit.getPlayer((UUID)uuid));
    }

    public Optional<String> getName(long discordId) {
        UUID uuid = this.linkedPlayers.get(discordId);
        return uuid == null ? Optional.empty() : Optional.ofNullable(Bukkit.getOfflinePlayer((UUID)uuid).getName());
    }

    public void linkPlayer(long discordId, UUID uuid) {
        this.linkedPlayers.put(discordId, uuid);
    }

    public void unlinkPlayer(long discordId) {
        this.linkedPlayers.remove(discordId);
    }

    public boolean isLinked(long discordId) {
        return this.linkedPlayers.containsKey(discordId);
    }

    public Map<Long, UUID> getLinkedPlayers() {
        return this.linkedPlayers;
    }

    public Collection<TicketType> getTicketTypes() {
        return this.ticketTypes.values();
    }
}

