/*
 * Decompiled with CFR 0.152.
 */
package de.gamingkaetzchen.synccord.tickets;

import de.gamingkaetzchen.synccord.Synccord;
import de.gamingkaetzchen.synccord.tickets.TicketQuestion;
import de.gamingkaetzchen.synccord.util.Lang;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.EmbedBuilder;

public class TicketType {
    private final String id;
    private final String name;
    private final String description;
    private final String buttonName;
    private final String categoryId;
    private final List<String> supporterRoles;
    private final Map<Integer, TicketQuestion> questions;
    private final Map<String, TicketType> ticketTypes = new HashMap<String, TicketType>();

    public TicketType(String id, String name, String description, String buttonName, String categoryId, List<String> supporterRoles, Map<Integer, TicketQuestion> questions) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.buttonName = buttonName;
        this.categoryId = categoryId;
        this.supporterRoles = supporterRoles;
        this.questions = questions;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getButtonName() {
        return this.buttonName;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public List<String> getSupporterRoles() {
        return this.supporterRoles;
    }

    public Map<Integer, TicketQuestion> getQuestions() {
        return this.questions;
    }

    public EmbedBuilder toFancyEmbed() {
        EmbedBuilder embed = new EmbedBuilder();
        embed.setTitle("\ud83d\udce9 " + this.getName());
        embed.setDescription(this.getDescription());
        embed.setColor(3092790);
        if (Synccord.getInstance().getDiscordBot() != null && Synccord.getInstance().getDiscordBot().getJDA() != null) {
            String botAvatar = Synccord.getInstance().getDiscordBot().getJDA().getSelfUser().getEffectiveAvatarUrl();
            embed.setThumbnail(botAvatar);
            embed.setFooter(Lang.get("ticket_embed_footer"), botAvatar);
        } else {
            embed.setFooter(Lang.get("ticket_embed_footer"));
        }
        if (this.categoryId != null && !this.categoryId.isEmpty()) {
            embed.addField("\ud83d\udcc1 Kategorie", "<#" + this.categoryId + ">", true);
        }
        if (this.supporterRoles != null && !this.supporterRoles.isEmpty()) {
            String rolesFormatted = this.supporterRoles.stream().map(roleId -> "<@&" + roleId + ">").reduce((a, b) -> a + "\n" + b).orElse("N/A");
            embed.addField("\ud83d\udc65 Supporter-Rollen", rolesFormatted, true);
        }
        embed.addField("\u2753 Fragen", String.valueOf(this.questions.size()), true);
        return embed;
    }

    public Collection<TicketType> getTicketTypes() {
        return this.ticketTypes.values();
    }
}

