/*
 * Decompiled with CFR 0.152.
 */
package de.blizzardsmp.synccord;

import de.blizzardsmp.synccord.commands.DcFindCommand;
import de.blizzardsmp.synccord.commands.UnlinkDiscordCommand;
import de.blizzardsmp.synccord.database.DatabaseManager;
import de.blizzardsmp.synccord.discord.DiscordBot;
import de.blizzardsmp.synccord.discord.InfoUpdaterOffline;
import de.blizzardsmp.synccord.listener.RoleSyncJoinListener;
import de.blizzardsmp.synccord.shaded.bstats.bukkit.Metrics;
import de.blizzardsmp.synccord.util.Lang;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Synccord
extends JavaPlugin {
    private static Synccord instance;
    private DiscordBot discordBot;
    private LuckPerms luckPerms;
    private boolean debug;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.debug = this.getConfig().getBoolean("debug", false);
        Lang.init();
        int pluginId = 26581;
        Metrics metrics = new Metrics(this, pluginId);
        DatabaseManager.init();
        this.getCommand("unlinkdiscord").setExecutor((CommandExecutor)new UnlinkDiscordCommand());
        this.getCommand("dcfind").setExecutor((CommandExecutor)new DcFindCommand());
        Bukkit.getPluginManager().registerEvents((Listener)new RoleSyncJoinListener(), (Plugin)this);
        try {
            this.luckPerms = LuckPermsProvider.get();
        }
        catch (IllegalStateException e) {
            this.getLogger().warning("\u26a0 LuckPerms nicht verf\u00fcgbar!");
        }
        try {
            this.discordBot = new DiscordBot(this.getConfig().getString("discord.token"));
        }
        catch (Exception e) {
            this.getLogger().severe("\u274c Fehler beim Starten des Discord-Bots:");
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        InfoUpdaterOffline.sendOfflineEmbedSync();
        if (this.discordBot != null) {
            this.discordBot.shutdown();
        }
    }

    public static Synccord getInstance() {
        return instance;
    }

    public DiscordBot getDiscordBot() {
        return this.discordBot;
    }

    public LuckPerms getLuckPerms() {
        return this.luckPerms;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public static void debug(String message) {
        if (Synccord.getInstance().isDebug()) {
            Synccord.getInstance().getLogger().info("\u00a78[\u00a73Debug\u00a78] \u00a77" + message);
        }
    }
}

