/*
 * Decompiled with CFR 0.152.
 */
package de.blizzardsmp.synccord.commands;

import de.blizzardsmp.synccord.Synccord;
import de.blizzardsmp.synccord.database.DatabaseManager;
import de.blizzardsmp.synccord.discord.LinkManager;
import de.blizzardsmp.synccord.util.Lang;
import java.util.Optional;
import java.util.UUID;
import net.dv8tion.jda.api.JDA;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class DcFindCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (!sender.hasPermission("synccord.admin")) {
            sender.sendMessage("\u00a7cKeine Berechtigung.");
            return true;
        }
        if (args2.length != 1) {
            sender.sendMessage(Lang.get("dcfind_usage"));
            return true;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)args2[0]);
        UUID uuid = player.getUniqueId();
        if (this.isDebug()) {
            Bukkit.getLogger().info(Lang.get("debug_dcfind_start").replace("%name%", args2[0]).replace("%uuid%", uuid.toString()));
        }
        if (!DatabaseManager.isLinked(uuid)) {
            sender.sendMessage(Lang.get("dcfind_not_found").replace("%name%", args2[0]));
            return true;
        }
        Optional<String> discordIdOpt = LinkManager.getDiscordId(uuid);
        if (discordIdOpt.isEmpty()) {
            if (this.isDebug()) {
                Bukkit.getLogger().info(Lang.get("debug_dcfind_noid").replace("%uuid%", uuid.toString()));
            }
            sender.sendMessage(Lang.get("dcfind_not_found").replace("%name%", args2[0]));
            return true;
        }
        String discordId = discordIdOpt.get();
        JDA jda = Synccord.getInstance().getDiscordBot().getJDA();
        if (this.isDebug()) {
            Bukkit.getLogger().info(Lang.get("debug_dcfind_foundid").replace("%id%", discordId));
        }
        jda.retrieveUserById(discordId).queue(user -> {
            sender.sendMessage(Lang.get("dcfind_success").replace("%name%", player.getName() != null ? player.getName() : "???").replace("%id%", discordId).replace("%tag%", user.getAsTag()));
            if (this.isDebug()) {
                Bukkit.getLogger().info(Lang.get("debug_dcfind_tag").replace("%tag%", user.getAsTag()));
            }
        }, error -> sender.sendMessage(Lang.get("dcfind_user_unknown").replace("%id%", discordId)));
        return true;
    }

    private boolean isDebug() {
        return Synccord.getInstance().getConfig().getBoolean("debug", false);
    }
}

