/*
 * Decompiled with CFR 0.152.
 */
package de.blizzardsmp.synccord.commands;

import de.blizzardsmp.synccord.Synccord;
import de.blizzardsmp.synccord.database.DatabaseManager;
import de.blizzardsmp.synccord.util.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class UnlinkDiscordCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (!sender.hasPermission("synccord.admin")) {
            sender.sendMessage("\u00a7cDu hast keine Berechtigung.");
            return true;
        }
        if (args2.length != 1) {
            sender.sendMessage("\u00a77Verwendung: /unlinkdiscord <spielername>");
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args2[0]);
        if (target.getName() == null) {
            sender.sendMessage("\u00a7cSpieler wurde nie auf dem Server gesehen.");
            return true;
        }
        UUID uuid = target.getUniqueId();
        if (this.isDebug()) {
            Bukkit.getLogger().info("[Synccord] Unlink-Versuch f\u00fcr UUID: " + String.valueOf(uuid) + " (" + target.getName() + ")");
        }
        if (!DatabaseManager.isLinked(uuid)) {
            String msg = Lang.get("unlink_not_found").replace("%name%", target.getName());
            sender.sendMessage(msg.replace("&", "\u00a7"));
            if (this.isDebug()) {
                Bukkit.getLogger().info("[Synccord] Keine Verkn\u00fcpfung f\u00fcr " + String.valueOf(uuid) + " gefunden.");
            }
            return true;
        }
        DatabaseManager.unlink(uuid);
        String msg = Lang.get("unlink_success").replace("%name%", target.getName());
        sender.sendMessage(msg.replace("&", "\u00a7"));
        if (this.isDebug()) {
            Bukkit.getLogger().info("[Synccord] Discord-Verkn\u00fcpfung entfernt f\u00fcr " + String.valueOf(uuid));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args2) {
        if (args2.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
                if (p.getName() == null || !p.getName().toLowerCase().startsWith(args2[0].toLowerCase()) || !DatabaseManager.isLinked(p.getUniqueId())) continue;
                suggestions.add(p.getName());
            }
            return suggestions;
        }
        return Collections.emptyList();
    }

    private boolean isDebug() {
        return Synccord.getInstance().getConfig().getBoolean("debug", false);
    }
}

