/*
 * Decompiled with CFR 0.152.
 */
package de.blizzardsmp.synccord.discord;

import de.blizzardsmp.synccord.Synccord;
import de.blizzardsmp.synccord.discord.InfoButtonListener;
import de.blizzardsmp.synccord.discord.InfoUpdater;
import de.blizzardsmp.synccord.discord.LinkHandler;
import de.blizzardsmp.synccord.discord.commands.LinkMCCommand;
import de.blizzardsmp.synccord.discord.commands.SetupCommand;
import de.blizzardsmp.synccord.discord.commands.UnlinkMCCommand;
import de.blizzardsmp.synccord.util.Lang;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.requests.GatewayIntent;

public class DiscordBot {
    private final JDA jda;

    public DiscordBot(String token) throws Exception {
        if (this.isDebug()) {
            Synccord.getInstance().getLogger().info(Lang.get("debug_discord_starting"));
        }
        this.jda = JDABuilder.createDefault(token).enableIntents(GatewayIntent.GUILD_MESSAGES, GatewayIntent.GUILD_MEMBERS, GatewayIntent.MESSAGE_CONTENT).addEventListeners(new SetupCommand(), new LinkHandler(), new InfoButtonListener(), new LinkMCCommand(), new UnlinkMCCommand()).build();
        this.jda.awaitReady();
        if (this.isDebug()) {
            Synccord.getInstance().getLogger().info(Lang.get("debug_discord_ready"));
        }
        this.registerCommands();
        InfoUpdater.recoverOrOffline(this.jda);
    }

    private void registerCommands() {
        if (this.isDebug()) {
            Synccord.getInstance().getLogger().info(Lang.get("debug_registering_slash_commands"));
        }
        this.jda.updateCommands().addCommands(Commands.slash("setup", Lang.get("setup_description")).addOption(OptionType.STRING, "type", Lang.get("setup_option_type_description"), true, true), Commands.slash("linkmc", Lang.get("linkmc_description")).addOption(OptionType.STRING, "uuid", Lang.get("linkmc_option_uuid"), true).addOption(OptionType.STRING, "discordid", Lang.get("linkmc_option_discordid"), true), Commands.slash("unlinkmc", Lang.get("unlinkmc_description")).addOption(OptionType.STRING, "uuid", Lang.get("unlinkmc_option_uuid"), true)).queue();
    }

    public void shutdown() {
        if (this.jda != null) {
            if (this.isDebug()) {
                Synccord.getInstance().getLogger().info(Lang.get("debug_discord_shutdown"));
            }
            this.jda.shutdown();
        }
    }

    public JDA getJDA() {
        return this.jda;
    }

    private boolean isDebug() {
        return Synccord.getInstance().getConfig().getBoolean("debug", false);
    }
}

