/*
 * Decompiled with CFR 0.152.
 */
package de.blizzardsmp.synccord.discord;

import de.blizzardsmp.synccord.Synccord;
import de.blizzardsmp.synccord.util.Lang;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import org.bukkit.Bukkit;

public class InfoButtonListener
extends ListenerAdapter {
    @Override
    public void onButtonInteraction(ButtonInteractionEvent event) {
        Member member;
        String buttonId = event.getComponentId();
        if (buttonId == null || !buttonId.equals("show_players")) {
            return;
        }
        if (this.isDebug()) {
            Synccord.getInstance().getLogger().info(Lang.get("debug_button_click").replace("%user%", event.getUser().getAsTag()));
        }
        if ((member = event.getMember()) == null || !member.hasPermission(Permission.ADMINISTRATOR)) {
            if (this.isDebug()) {
                Synccord.getInstance().getLogger().info(Lang.get("debug_button_no_permission").replace("%user%", event.getUser().getAsTag()));
            }
            event.reply(Lang.get("no_permission")).setEphemeral(true).queue();
            return;
        }
        String players = Bukkit.getOnlinePlayers().stream().map(p -> "\u2022 " + p.getName()).collect(Collectors.joining("\n"));
        if (players.isEmpty()) {
            players = Lang.get("info_players_empty");
        }
        if (this.isDebug()) {
            Synccord.getInstance().getLogger().info(Lang.get("debug_sending_player_list"));
        }
        event.reply("**" + Lang.get("info_players_title") + "**\n" + players).setEphemeral(true).queue();
    }

    private boolean isDebug() {
        return Synccord.getInstance().getConfig().getBoolean("debug", false);
    }
}

