/*
 * Decompiled with CFR 0.152.
 */
package de.blizzardsmp.synccord.discord;

import de.blizzardsmp.synccord.Synccord;
import de.blizzardsmp.synccord.discord.InfoUpdater;
import de.blizzardsmp.synccord.util.Lang;
import java.awt.Color;
import java.time.Instant;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;

public class InfoUpdaterOffline {
    public static void sendOfflineEmbedSync() {
        String channelId = InfoUpdater.getLastChannelId();
        String messageId = InfoUpdater.getLastMessageId();
        if (channelId == null || messageId == null) {
            InfoUpdaterOffline.debugLog(Lang.get("debug_offline_no_saved_message"));
            return;
        }
        MessageChannel channel = Synccord.getInstance().getDiscordBot().getJDA().getChannelById(MessageChannel.class, channelId);
        if (channel == null) {
            InfoUpdaterOffline.debugLog(Lang.get("debug_offline_channel_not_found").replace("%id%", channelId));
            return;
        }
        String iconUrl = Synccord.getInstance().getDiscordBot().getJDA().getSelfUser().getAvatarUrl();
        EmbedBuilder embed = new EmbedBuilder().setTitle(Lang.get("info_embed_title")).setDescription(Lang.get("info_embed_offline")).setThumbnail(iconUrl).setFooter(Lang.get("info_embed_footer"), iconUrl).setColor(Color.RED).setTimestamp(Instant.now());
        try {
            Message msg = channel.retrieveMessageById(messageId).complete();
            ((MessageEditAction)msg.editMessageEmbeds(embed.build()).setActionRow(Button.primary("show_players", "\ud83d\udd0d " + Lang.get("show_players_button")).asDisabled())).complete();
            InfoUpdaterOffline.debugLog(Lang.get("debug_offline_embed_replaced"));
        }
        catch (Exception e) {
            Synccord.getInstance().getLogger().warning(Lang.get("debug_offline_replace_failed"));
            e.printStackTrace();
        }
    }

    private static void debugLog(String msg) {
        if (Synccord.getInstance().getConfig().getBoolean("debug", false)) {
            Synccord.getInstance().getLogger().info("\ud83e\udeb2 DEBUG | " + msg);
        }
    }
}

