/*
 * Decompiled with CFR 0.152.
 */
package de.blizzardsmp.synccord.discord;

import de.blizzardsmp.synccord.Synccord;
import de.blizzardsmp.synccord.database.DatabaseManager;
import de.blizzardsmp.synccord.util.Lang;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;

public class LinkManager {
    private static final Map<UUID, CodeEntry> activeCodes = new HashMap<UUID, CodeEntry>();
    private static final Map<String, UUID> reverseCodes = new HashMap<String, UUID>();

    public static boolean isLinked(UUID uuid) {
        return DatabaseManager.isLinked(uuid);
    }

    public static String generateCodeFor(UUID uuid) {
        long now = System.currentTimeMillis();
        CodeEntry existing = activeCodes.get(uuid);
        if (existing != null && existing.expiresAt > now) {
            LinkManager.debugLog(Lang.get("debug_link_code_still_valid").replace("%uuid%", uuid.toString()).replace("%code%", existing.code));
            return existing.code;
        }
        String code = LinkManager.generateUniqueCode(6);
        long expiryMinutes = Synccord.getInstance().getConfig().getLong("linking.code-expiry-minutes", 0L);
        long expiresAt = expiryMinutes > 0L ? now + expiryMinutes * 60000L : Long.MAX_VALUE;
        activeCodes.put(uuid, new CodeEntry(code, expiresAt));
        reverseCodes.put(code, uuid);
        LinkManager.debugLog(Lang.get("debug_link_code_generated").replace("%uuid%", uuid.toString()).replace("%code%", code).replace("%minutes%", String.valueOf(expiryMinutes)));
        return code;
    }

    public static UUID getUUIDByCode(String code) {
        UUID uuid = reverseCodes.get(code);
        if (uuid == null) {
            LinkManager.debugLog(Lang.get("debug_link_code_not_found").replace("%code%", code));
            return null;
        }
        CodeEntry entry = activeCodes.get(uuid);
        if (entry == null || System.currentTimeMillis() > entry.expiresAt) {
            LinkManager.debugLog(Lang.get("debug_link_code_expired").replace("%code%", code).replace("%uuid%", uuid.toString()));
            activeCodes.remove(uuid);
            reverseCodes.remove(code);
            return null;
        }
        LinkManager.debugLog(Lang.get("debug_link_code_valid").replace("%code%", code).replace("%uuid%", uuid.toString()));
        return uuid;
    }

    public static void link(UUID uuid, String discordId) {
        activeCodes.remove(uuid);
        reverseCodes.entrySet().removeIf(entry -> ((UUID)entry.getValue()).equals(uuid));
        DatabaseManager.link(uuid, discordId);
        LinkManager.debugLog(Lang.get("debug_link_stored").replace("%uuid%", uuid.toString()).replace("%id%", discordId));
    }

    public static Optional<String> getDiscordId(UUID uuid) {
        return DatabaseManager.getDiscordId(uuid);
    }

    private static String generateUniqueCode(int length) {
        String code;
        String chars = "ABCDEFGHJKLMNPQRSTUVWXYZ23456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        do {
            sb.setLength(0);
            for (int i = 0; i < length; ++i) {
                sb.append(chars.charAt(random.nextInt(chars.length())));
            }
        } while (reverseCodes.containsKey(code = sb.toString()));
        return code;
    }

    private static void debugLog(String msg) {
        if (Synccord.getInstance().getConfig().getBoolean("debug", false)) {
            Synccord.getInstance().getLogger().info("\ud83e\udeb2 DEBUG | " + msg);
        }
    }

    private record CodeEntry(String code, long expiresAt) {
    }
}

