/*
 * Decompiled with CFR 0.152.
 */
package de.blizzardsmp.synccord.discord;

import de.blizzardsmp.synccord.Synccord;
import de.blizzardsmp.synccord.util.Lang;
import java.util.Map;
import java.util.UUID;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.ScopedNode;
import org.bukkit.configuration.ConfigurationSection;

public class RoleSyncUtil {
    public static void syncRolesToMinecraft(Member member, UUID uuid) {
        RoleSyncUtil.debugLog(Lang.get("sync_start").replace("%uuid%", uuid.toString()));
        ConfigurationSection discordSection = Synccord.getInstance().getConfig().getConfigurationSection("discord");
        if (discordSection == null) {
            Synccord.getInstance().getLogger().warning("\u26a0 'discord' section not found in config.yml");
            return;
        }
        ConfigurationSection roleLinkSection = discordSection.getConfigurationSection("role-link");
        if (roleLinkSection == null) {
            Synccord.getInstance().getLogger().warning(Lang.get("sync_no_roles_config"));
            return;
        }
        Map roleMap = roleLinkSection.getValues(false);
        if (roleMap.isEmpty()) {
            Synccord.getInstance().getLogger().warning(Lang.get("sync_no_roles_config"));
            return;
        }
        LuckPerms lp = Synccord.getInstance().getLuckPerms();
        User user = lp.getUserManager().getUser(uuid);
        if (user == null) {
            Synccord.getInstance().getLogger().warning(Lang.get("sync_no_lp_user").replace("%uuid%", uuid.toString()));
            return;
        }
        RoleSyncUtil.debugLog(Lang.get("sync_discord_roles"));
        for (Role role : member.getRoles()) {
            RoleSyncUtil.debugLog(" - " + role.getName() + " (" + role.getId() + ")");
        }
        for (Map.Entry entry : roleMap.entrySet()) {
            String roleId = (String)entry.getKey();
            String groupName = String.valueOf(entry.getValue());
            Role role = member.getGuild().getRoleById(roleId);
            if (role == null) {
                Synccord.getInstance().getLogger().warning(Lang.get("sync_role_not_found").replace("%role%", roleId));
                continue;
            }
            boolean hasDiscordRole = member.getRoles().contains(role);
            boolean hasGroup = user.getNodes().stream().anyMatch(n -> n.getKey().equals("group." + groupName));
            RoleSyncUtil.debugLog(Lang.get("sync_check").replace("%role%", role.getName()).replace("%group%", groupName));
            RoleSyncUtil.debugLog(" \u2192 " + Lang.get("sync_has_role") + ": " + hasDiscordRole + ", " + Lang.get("sync_has_group") + ": " + hasGroup);
            ScopedNode node = Node.builder((String)("group." + groupName)).build();
            if (hasDiscordRole && !hasGroup) {
                lp.getUserManager().modifyUser(uuid, arg_0 -> RoleSyncUtil.lambda$syncRolesToMinecraft$1((Node)node, arg_0));
                RoleSyncUtil.debugLog(Lang.get("sync_added").replace("%group%", groupName));
                continue;
            }
            if (!hasDiscordRole && hasGroup) {
                lp.getUserManager().modifyUser(uuid, arg_0 -> RoleSyncUtil.lambda$syncRolesToMinecraft$2((Node)node, arg_0));
                RoleSyncUtil.debugLog(Lang.get("sync_removed").replace("%group%", groupName));
                continue;
            }
            RoleSyncUtil.debugLog(Lang.get("sync_no_change").replace("%group%", groupName));
        }
        RoleSyncUtil.debugLog(Lang.get("sync_done"));
    }

    private static void debugLog(String msg) {
        if (Synccord.getInstance().getConfig().getBoolean("debug", false)) {
            Synccord.getInstance().getLogger().info("\ud83e\udeb2 DEBUG | " + msg);
        }
    }

    private static /* synthetic */ void lambda$syncRolesToMinecraft$2(Node node, User u) {
        u.data().remove(node);
    }

    private static /* synthetic */ void lambda$syncRolesToMinecraft$1(Node node, User u) {
        u.data().add(node);
    }
}

