/*
 * Decompiled with CFR 0.152.
 */
package de.blizzardsmp.synccord.util;

import de.blizzardsmp.synccord.Synccord;
import java.io.File;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class Lang {
    private static YamlConfiguration langFile;
    private static YamlConfiguration fallbackFile;

    public static void init() {
        String lang = Synccord.getInstance().getConfig().getString("language", "en");
        File langDir = new File(Synccord.getInstance().getDataFolder(), "lang");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        File langFilePath = new File(langDir, lang + ".yml");
        File fallbackPath = new File(langDir, "en.yml");
        if (!langFilePath.exists()) {
            Synccord.getInstance().saveResource("lang/" + lang + ".yml", false);
        }
        if (!fallbackPath.exists()) {
            Synccord.getInstance().saveResource("lang/en.yml", false);
        }
        langFile = YamlConfiguration.loadConfiguration((File)langFilePath);
        fallbackFile = YamlConfiguration.loadConfiguration((File)fallbackPath);
    }

    public static String get(String key) {
        if (key == null || key.isEmpty()) {
            return "\u00a7c[Invalid lang key]";
        }
        if (key.equals("prefix")) {
            String rawPrefix = langFile.getString("prefix", fallbackFile.getString("prefix"));
            return rawPrefix != null ? rawPrefix : "\u00a77[\u00a7bSynccord\u00a77] ";
        }
        String msg = langFile.getString(key);
        if (msg == null) {
            msg = fallbackFile.getString(key);
        }
        if (msg == null) {
            if (Synccord.getInstance().getConfig().getBoolean("debug", false)) {
                Bukkit.getLogger().warning("\u26a0 [Synccord] Sprachschl\u00fcssel fehlt: " + key);
            }
            return "\u00a7c[Missing lang key: " + key + "]";
        }
        return msg.replace("%prefix%", Lang.get("prefix"));
    }

    public static String get(String key, Map<String, String> placeholders) {
        String msg = Lang.get(key);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                msg = msg.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return msg;
    }
}

