/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.animation.AzAnimationContext;
import mod.azure.azurelib.animation.AzAnimator;
import mod.azure.azurelib.animation.AzAnimatorAccessor;
import mod.azure.azurelib.animation.cache.AzBoneCache;
import mod.azure.azurelib.model.AzBakedModel;
import mod.azure.azurelib.model.cache.AzBakedModelCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzProvider<K, T> {
    protected final Supplier<AzAnimator<K, T>> animatorSupplier;
    protected final BiFunction<Entity, T, ResourceLocation> modelLocationProvider;
    protected final Function<T, K> UUIDProvider;

    public AzProvider(Supplier<AzAnimator<K, T>> animatorSupplier, BiFunction<Entity, T, ResourceLocation> modelLocationProvider, Function<T, K> UUIDProvider) {
        this.animatorSupplier = animatorSupplier;
        this.modelLocationProvider = modelLocationProvider;
        this.UUIDProvider = UUIDProvider;
    }

    @Nullable
    public AzBakedModel provideBakedModel(@Nullable Entity entity, @NotNull T animatable) {
        ResourceLocation modelLocation = this.modelLocationProvider.apply(entity, (Entity)animatable);
        AzBakedModel shared = AzBakedModelCache.getInstance().getNullable(modelLocation);
        if (shared == null) {
            return AzBakedModel.getDefault();
        }
        AzAnimator animator = AzAnimatorAccessor.getOrNull(animatable);
        if (animator == null) {
            return shared;
        }
        AzAnimationContext<T> ctx = animator.context();
        if (ctx == null) {
            return shared;
        }
        AzBoneCache cache = ctx.boneCache();
        if (cache == null || cache.isEmpty()) {
            return shared;
        }
        return cache.getBakedModel();
    }

    @Nullable
    public AzAnimator<K, T> provideAnimator(@Nullable Entity entity, T animatable) {
        AzAnimatorAccessor accessor = AzAnimatorAccessor.cast(animatable);
        AzAnimator<K, T> cachedAnimator = accessor.getAnimatorOrNull();
        if (cachedAnimator == null && (cachedAnimator = this.animatorSupplier.get()) != null) {
            AzAnimationContext<T> ctx = cachedAnimator.getOrCreateContext(this.UUIDProvider.apply(animatable));
            ResourceLocation modelLocation = this.modelLocationProvider.apply(entity, (Entity)animatable);
            AzBakedModel shared = AzBakedModelCache.getInstance().getNullable(modelLocation);
            if (shared != null) {
                ctx.boneCache().setActiveModel(shared);
            }
            cachedAnimator.registerControllers(cachedAnimator.getAnimationControllerContainer());
            accessor.setAnimator(cachedAnimator);
        }
        return cachedAnimator;
    }
}

