/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.UUID;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzModelRenderer;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.entity.AzEntityLayerRenderer;
import mod.azure.azurelib.render.entity.AzEntityLeashRenderUtil;
import mod.azure.azurelib.render.entity.AzEntityRenderer;
import mod.azure.azurelib.render.entity.AzEntityRendererConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;

public class AzEntityRendererPipeline<T extends Entity>
extends AzRendererPipeline<UUID, T> {
    private final AzEntityRenderer<T> entityRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzEntityRendererPipeline(AzEntityRendererConfig<T> config, AzEntityRenderer<T> entityRenderer) {
        super(config);
        this.entityRenderer = entityRenderer;
    }

    @Override
    protected AzRendererPipelineContext<UUID, T> createContext(AzRendererPipeline<UUID, T> rendererPipeline) {
        return this.config.pipelineContext(this);
    }

    @Override
    protected AzModelRenderer<UUID, T> createModelRenderer(AzLayerRenderer<UUID, T> layerRenderer) {
        return this.config.modelRendererProvider(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<UUID, T> createLayerRenderer(AzRendererConfig<UUID, T> config) {
        return new AzEntityLayerRenderer(config::renderLayers);
    }

    @Override
    public void updateAnimatedTextureFrame(T entity) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(this.context().currentEntity(), entity));
    }

    @Override
    public void preRender(AzRendererPipelineContext<UUID, T> context, boolean isReRender) {
        PoseStack poseStack = context.poseStack();
        this.entityRenderTranslations.m_162210_(poseStack.m_85850_().m_85861_());
        AzEntityRendererConfig<Object> config = this.entityRenderer.config();
        float scaleWidth = config.scaleWidth((Entity)context.animatable());
        float scaleHeight = config.scaleHeight((Entity)context.animatable());
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (config.alpha((Entity)context.animatable()) < 1.0f || ((Entity)context.animatable()).m_20145_()) {
            float setAlpha = ((Entity)context.animatable()).m_20145_() ? (((Entity)context.animatable()).m_20177_((Player)Minecraft.m_91087_().f_91074_) ? 0.0f : 0.38f) : config.alpha((Entity)context.animatable());
            context.setAlpha(setAlpha);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<UUID, T> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    @Override
    public void renderFinal(AzRendererPipelineContext<UUID, T> context) {
        MultiBufferSource bufferSource = context.multiBufferSource();
        Entity entity = (Entity)context.animatable();
        int packedLight = context.packedLight();
        float partialTick = context.partialTick();
        PoseStack poseStack = context.poseStack();
        this.entityRenderer.superRender(entity, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        Entity leashHolder = mob.m_21524_();
        if (leashHolder == null) {
            return;
        }
        AzEntityLeashRenderUtil.renderLeash(this.entityRenderer, mob, partialTick, poseStack, bufferSource, leashHolder);
    }

    @Override
    protected void doPostRenderCleanup(AzRendererPipelineContext<UUID, T> context) {
        context.setCurrentEntity(null);
    }

    public AzEntityRenderer<T> getRenderer() {
        return this.entityRenderer;
    }
}

