/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.cache.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.cache.texture.AutoGlowingTexture;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4573;

public class AnimatableTexture
extends class_1049 {
    protected AnimationContents animationContents = null;
    protected boolean isAnimated = false;

    public AnimatableTexture(class_2960 location) {
        super(location);
    }

    public void method_4625(class_3300 manager) throws IOException {
        class_3298 resource = manager.method_14486(this.field_5224);
        class_1079 animMeta = (class_1079)resource.method_14481((class_3270)class_1079.field_5337);
        if (animMeta != null) {
            class_1011 nativeImage;
            try (InputStream inputstream = resource.method_14482();){
                nativeImage = class_1011.method_4309((InputStream)inputstream);
            }
            this.animationContents = new AnimationContents(nativeImage, animMeta);
            if (!this.animationContents.isValid()) {
                nativeImage.close();
                return;
            }
            this.isAnimated = true;
            AnimatableTexture.onRenderThread(() -> {
                TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)((Integer)this.animationContents.frameSize.getFirst()), (int)((Integer)this.animationContents.frameSize.getSecond()));
                nativeImage.method_4312(0, 0, 0, 0, 0, ((Integer)this.animationContents.frameSize.getFirst()).intValue(), ((Integer)this.animationContents.frameSize.getSecond()).intValue(), false, false);
            });
        }
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public static void setAndUpdate(class_2960 texturePath) {
        AnimatableTexture.setAndUpdate(texturePath, (int)RenderUtils.getCurrentTick());
    }

    public static void setAndUpdate(class_2960 texturePath, int frameTick) {
        class_1044 texture = class_310.method_1551().method_1531().method_4619(texturePath);
        if (texture instanceof AnimatableTexture) {
            AnimatableTexture animatableTexture = (AnimatableTexture)texture;
            animatableTexture.setAnimationFrame(frameTick);
        }
        RenderSystem.setShaderTexture((int)0, (int)texture.method_4624());
    }

    public void setAnimationFrame(int tick) {
        if (this.animationContents != null) {
            this.animationContents.animatedTexture.setCurrentFrame(tick);
        }
    }

    protected static void onRenderThread(class_4573 renderCall) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall((class_4573)renderCall);
        } else {
            renderCall.execute();
        }
    }

    protected class AnimationContents {
        protected final Pair<Integer, Integer> frameSize;
        protected final Texture animatedTexture;

        protected AnimationContents(class_1011 image, class_1079 animMeta) {
            this.frameSize = animMeta.method_24141(image.method_4307(), image.method_4323());
            this.animatedTexture = this.generateAnimatedTexture(image, animMeta);
        }

        protected boolean isValid() {
            return this.animatedTexture != null;
        }

        protected Texture generateAnimatedTexture(class_1011 image, class_1079 animMeta) {
            if (!AzureLibUtil.isMultipleOf(image.method_4307(), (Integer)this.frameSize.getFirst()) || !AzureLibUtil.isMultipleOf(image.method_4323(), (Integer)this.frameSize.getSecond())) {
                AzureLib.LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", (Object)AnimatableTexture.this.field_5224, (Object)image.method_4307(), (Object)image.method_4323(), this.frameSize.getFirst(), this.frameSize.getSecond());
                return null;
            }
            int columns = image.method_4307() / (Integer)this.frameSize.getFirst();
            int rows = image.method_4323() / (Integer)this.frameSize.getSecond();
            int frameCount = columns * rows;
            ObjectArrayList frames = new ObjectArrayList();
            animMeta.method_33460((arg_0, arg_1) -> AnimationContents.lambda$generateAnimatedTexture$0((List)frames, arg_0, arg_1));
            if (frames.isEmpty()) {
                for (int frame = 0; frame < frameCount; ++frame) {
                    frames.add(new Frame(frame, animMeta.method_4684()));
                }
            } else {
                int index = 0;
                IntOpenHashSet unusedFrames = new IntOpenHashSet();
                for (Frame frame : frames) {
                    if (frame.time <= 0) {
                        AzureLib.LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)AnimatableTexture.this.field_5224, (Object)index, (Object)frame.time);
                        unusedFrames.add(frame.index);
                    } else if (frame.index < 0 || frame.index >= frameCount) {
                        AzureLib.LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", (Object)AnimatableTexture.this.field_5224, (Object)index, (Object)frame.index);
                        unusedFrames.add(frame.index);
                    }
                    ++index;
                }
                if (!unusedFrames.isEmpty()) {
                    AzureLib.LOGGER.warn("Unused frames in sprite {}: {}", (Object)AnimatableTexture.this.field_5224, (Object)Arrays.toString(unusedFrames.toArray()));
                }
            }
            return frames.size() <= 1 ? null : new Texture(image, frames.toArray(new Frame[0]), columns, animMeta.method_4685());
        }

        private static /* synthetic */ void lambda$generateAnimatedTexture$0(List frames, int frame, int frameTime) {
            frames.add(new Frame(frame, frameTime));
        }

        protected class Texture
        implements AutoCloseable {
            protected final class_1011 baseImage;
            protected final Frame[] frames;
            protected final int framePanelSize;
            protected final boolean interpolating;
            protected final class_1011 interpolatedFrame;
            protected final int totalFrameTime;
            protected int glowMaskTextureId = -1;
            protected class_1011 glowmaskImage = null;
            protected class_1011 glowmaskInterpolatedFrame = null;
            protected int currentFrame;
            protected int currentSubframe;

            protected Texture(class_1011 baseImage, Frame[] frames, int framePanelSize, boolean interpolating) {
                this.baseImage = baseImage;
                this.frames = frames;
                this.framePanelSize = framePanelSize;
                this.interpolating = interpolating;
                this.interpolatedFrame = interpolating ? new class_1011(((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false) : null;
                int time = 0;
                for (Frame frame : this.frames) {
                    time += frame.time;
                }
                this.totalFrameTime = time;
            }

            protected int getFrameX(int frameIndex) {
                return frameIndex % this.framePanelSize;
            }

            protected int getFrameY(int frameIndex) {
                return frameIndex / this.framePanelSize;
            }

            public void setGlowMaskTexture(AutoGlowingTexture texture, class_1011 baseImage, class_1011 glowMask) {
                this.glowMaskTextureId = texture.method_4624();
                this.glowmaskImage = glowMask;
                this.glowmaskInterpolatedFrame = this.interpolating ? new class_1011(((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false) : null;
                this.baseImage.method_4317(baseImage);
            }

            public void setCurrentFrame(int ticks) {
                if ((ticks %= this.totalFrameTime) == this.currentSubframe) {
                    return;
                }
                int lastSubframe = this.currentSubframe;
                int lastFrame = this.currentFrame;
                int time = 0;
                for (Frame frame : this.frames) {
                    if (ticks >= (time += frame.time)) continue;
                    this.currentFrame = frame.index;
                    this.currentSubframe = ticks % frame.time;
                    break;
                }
                if (this.currentFrame != lastFrame && this.currentSubframe == 0) {
                    AnimatableTexture.onRenderThread(() -> {
                        TextureUtil.prepareImage((int)AnimatableTexture.this.method_4624(), (int)0, (int)((Integer)AnimationContents.this.frameSize.getFirst()), (int)((Integer)AnimationContents.this.frameSize.getSecond()));
                        this.baseImage.method_4312(0, 0, 0, this.getFrameX(this.currentFrame) * (Integer)AnimationContents.this.frameSize.getFirst(), this.getFrameY(this.currentFrame) * (Integer)AnimationContents.this.frameSize.getSecond(), ((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false, false);
                    });
                } else if (this.currentSubframe != lastSubframe && this.interpolating) {
                    AnimatableTexture.onRenderThread(this::generateInterpolatedFrame);
                }
            }

            protected void generateInterpolatedFrame() {
                Frame frame = this.frames[this.currentFrame];
                double frameProgress = 1.0 - (double)this.currentSubframe / (double)frame.time;
                int nextFrameIndex = this.frames[(this.currentFrame + 1) % this.frames.length].index;
                if (frame.index != nextFrameIndex) {
                    for (int y = 0; y < this.interpolatedFrame.method_4323(); ++y) {
                        for (int x = 0; x < this.interpolatedFrame.method_4307(); ++x) {
                            int prevFramePixel = this.getPixel(frame.index, x, y);
                            int nextFramePixel = this.getPixel(nextFrameIndex, x, y);
                            int blendedRed = this.interpolate(frameProgress, prevFramePixel >> 16 & 0xFF, nextFramePixel >> 16 & 0xFF);
                            int blendedGreen = this.interpolate(frameProgress, prevFramePixel >> 8 & 0xFF, nextFramePixel >> 8 & 0xFF);
                            int blendedBlue = this.interpolate(frameProgress, prevFramePixel & 0xFF, nextFramePixel & 0xFF);
                            this.interpolatedFrame.method_4305(x, y, prevFramePixel & 0xFF000000 | blendedRed << 16 | blendedGreen << 8 | blendedBlue);
                        }
                    }
                    TextureUtil.prepareImage((int)AnimatableTexture.this.method_4624(), (int)0, (int)((Integer)AnimationContents.this.frameSize.getFirst()), (int)((Integer)AnimationContents.this.frameSize.getSecond()));
                    this.interpolatedFrame.method_4312(0, 0, 0, 0, 0, ((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false, false);
                }
            }

            protected int getPixel(int frameIndex, int x, int y) {
                return this.baseImage.method_4315(x + this.getFrameX(frameIndex) * (Integer)AnimationContents.this.frameSize.getFirst(), y + this.getFrameY(frameIndex) * (Integer)AnimationContents.this.frameSize.getSecond());
            }

            protected int interpolate(double frameProgress, double prevColour, double nextColour) {
                return (int)(frameProgress * prevColour + (1.0 - frameProgress) * nextColour);
            }

            @Override
            public void close() {
                this.baseImage.close();
                if (this.interpolatedFrame != null) {
                    this.interpolatedFrame.close();
                }
            }
        }

        protected record Frame(int index, int time) {
        }
    }
}

