/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import java.util.UUID;
import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.network.AzureLibNetwork;
import mod.azure.azurelib.rewrite.animation.cache.AzIdentifiableItemStackAnimatorCache;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.rewrite.animation.impl.AzItemAnimator;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class AzItemStackDispatchCommandPacket
extends AbstractPacket {
    private final UUID itemStackId;
    private final AzCommand dispatchCommand;

    public AzItemStackDispatchCommandPacket(UUID itemStackId, AzCommand dispatchCommand) {
        this.itemStackId = itemStackId;
        this.dispatchCommand = dispatchCommand;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(this.itemStackId);
        AzCommand.ENCODER.accept(buf, this.dispatchCommand);
        return buf;
    }

    public static AzItemStackDispatchCommandPacket receive(class_2540 buf) {
        UUID itemStackId = buf.method_10790();
        AzCommand dispatchCommand = AzCommand.DECODER.apply(buf);
        return new AzItemStackDispatchCommandPacket(itemStackId, dispatchCommand);
    }

    public void handle() {
        AzItemAnimator animator = AzIdentifiableItemStackAnimatorCache.getInstance().getOrNull(this.itemStackId);
        if (animator != null) {
            this.dispatchCommand.actions().forEach(action -> action.handle(AzDispatchSide.SERVER, animator));
        }
    }

    @Override
    public class_2960 getPacketID() {
        return AzureLibNetwork.AZ_ITEM_STACK_DISPATCH_COMMAND_SYNC_PACKET_ID;
    }
}

