/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.property.codec;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypeRegistry;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypes;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehaviorRegistry;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelib.rewrite.animation.property.AzAnimationStageProperties;
import net.minecraft.class_2540;

public class AzAnimationStagePropertiesCodec {
    public static final Function<class_2540, AzAnimationStageProperties> DECODER = buf -> {
        int propertyLength = buf.readByte();
        AzAnimationStageProperties properties = AzAnimationStageProperties.EMPTY;
        block6: for (int i = 0; i < propertyLength; ++i) {
            byte code = buf.readByte();
            switch (code) {
                case 0: {
                    properties = properties.withAnimationSpeed(buf.readDouble());
                    continue block6;
                }
                case 1: {
                    properties = properties.withTransitionLength(buf.readFloat());
                    continue block6;
                }
                case 2: {
                    AzEasingType easingType = AzEasingTypeRegistry.getOrDefault(buf.method_19772(), AzEasingTypes.NONE);
                    properties = properties.withEasingType(easingType);
                    continue block6;
                }
                case 3: {
                    AzPlayBehavior playBehavior = AzPlayBehaviorRegistry.getOrDefault(buf.method_19772(), AzPlayBehaviors.PLAY_ONCE);
                    properties = properties.withPlayBehavior(playBehavior);
                }
            }
        }
        return properties;
    };
    public static final BiConsumer<class_2540, AzAnimationStageProperties> ENCODER = (buf, properties) -> {
        int propertyLength = 0;
        propertyLength += properties.hasAnimationSpeed() ? 1 : 0;
        propertyLength += properties.hasTransitionLength() ? 1 : 0;
        propertyLength += properties.hasEasingType() ? 1 : 0;
        buf.writeByte(propertyLength += properties.hasPlayBehavior() ? 1 : 0);
        if (properties.hasAnimationSpeed()) {
            buf.writeByte(0);
            buf.writeDouble(properties.animationSpeed());
        }
        if (properties.hasTransitionLength()) {
            buf.writeByte(1);
            buf.writeFloat(properties.transitionLength());
        }
        if (properties.hasEasingType()) {
            buf.writeByte(2);
            buf.method_10814(properties.easingType().name());
        }
        if (properties.hasPlayBehavior()) {
            buf.writeByte(3);
            buf.method_10814(properties.playBehavior().name());
        }
    };
}

