/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.cache.object.GeoVertex;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class AzModelRenderer<T> {
    private final class_1159 poseStateCache = new class_1159();
    private final class_1160 normalCache = new class_1160();
    private final AzRendererPipeline<T> rendererPipeline;
    protected final AzLayerRenderer<T> layerRenderer;
    private final class_1162 poseStateTransformCache = new class_1162();

    public AzModelRenderer(AzRendererPipeline<T> rendererPipeline, AzLayerRenderer<T> layerRenderer) {
        this.layerRenderer = layerRenderer;
        this.rendererPipeline = rendererPipeline;
    }

    protected void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        T animatable = context.animatable();
        AzBakedModel model = context.bakedModel();
        this.rendererPipeline.updateAnimatedTextureFrame(animatable);
        for (AzBone bone : model.getTopLevelBones()) {
            this.renderRecursively(context, bone, isReRender);
        }
    }

    protected void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        class_4587 poseStack = context.poseStack();
        poseStack.method_22903();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.method_22909();
    }

    protected void renderCubesOfBone(AzRendererPipelineContext<T> context, AzBone bone) {
        if (bone.isHidden()) {
            return;
        }
        class_4587 poseStack = context.poseStack();
        for (GeoCube cube : bone.getCubes()) {
            poseStack.method_22903();
            this.renderCube(context, cube);
            poseStack.method_22909();
        }
    }

    protected void renderChildBones(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (AzBone childBone : bone.getChildBones()) {
            this.renderRecursively(context, childBone, isReRender);
        }
    }

    protected void renderCube(AzRendererPipelineContext<T> context, GeoCube cube) {
        class_4587 poseStack = context.poseStack();
        RenderUtils.translateToPivotPoint(poseStack, cube);
        RenderUtils.rotateMatrixAroundCube(poseStack, cube);
        RenderUtils.translateAwayFromPivotPoint(poseStack, cube);
        class_4581 normalisedPoseState = poseStack.method_23760().method_23762();
        class_1159 poseState = poseStack.method_23760().method_23761();
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            class_1160 normal = quad.normal().method_23850();
            normal.method_23215(normalisedPoseState);
            RenderUtils.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(context, quad, poseState, normal);
        }
    }

    protected void createVerticesOfQuad(AzRendererPipelineContext<T> context, GeoQuad quad, class_1159 poseState, class_1160 normal) {
        class_4588 buffer = context.vertexConsumer();
        int packedOverlay = context.packedOverlay();
        int packedLight = context.packedLight();
        for (GeoVertex vertex : quad.vertices()) {
            class_1160 position = vertex.position();
            class_1162 vector4f = new class_1162(position.method_4943(), position.method_4945(), position.method_4947(), 1.0f);
            vector4f.method_22674(poseState);
            buffer.method_23919(vector4f.method_4953(), vector4f.method_4956(), vector4f.method_4957(), context.red(), context.green(), context.blue(), context.alpha(), vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.method_4943(), normal.method_4945(), normal.method_4947());
        }
    }
}

