/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.cache.texture;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.cache.texture.GeoAbstractTexture;
import mod.azure.azurelib.platform.Services;
import mod.azure.azurelib.resource.GeoGlowingTextureMeta;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class AutoGlowingTexture
extends GeoAbstractTexture {
    private static final RenderStateShard.ShaderStateShard SHADER_STATE = new RenderStateShard.ShaderStateShard(GameRenderer::m_172700_);
    private static final RenderStateShard.TransparencyStateShard TRANSPARENCY_STATE = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    private static final RenderStateShard.WriteMaskStateShard WRITE_MASK = new RenderStateShard.WriteMaskStateShard(true, true);
    protected static final BiFunction<ResourceLocation, Boolean, RenderType> GLOWING_RENDER_TYPE = Util.m_143821_((texture, isGlowing) -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(texture, false, false);
        return RenderType.m_173215_((String)"az_glowing_layer", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(SHADER_STATE).m_173290_((RenderStateShard.EmptyTextureStateShard)textureState).m_110685_(TRANSPARENCY_STATE).m_110677_(new RenderStateShard.OverlayStateShard(true)).m_110687_(WRITE_MASK).m_110691_(isGlowing.booleanValue()));
    });
    private static final String APPENDIX = "_glowmask";
    protected final ResourceLocation textureBase;
    protected final ResourceLocation glowLayer;

    public AutoGlowingTexture(ResourceLocation originalLocation, ResourceLocation location) {
        this.textureBase = originalLocation;
        this.glowLayer = location;
    }

    public static ResourceLocation getEmissiveResource(ResourceLocation baseResource) {
        ResourceLocation path = AutoGlowingTexture.appendToPath(baseResource, APPENDIX);
        AutoGlowingTexture.generateTexture(path, textureManager -> textureManager.m_118495_(path, (AbstractTexture)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    @Override
    @Nullable
    protected RenderCall loadTexture(ResourceManager resourceManager, Minecraft mc) throws IOException {
        AnimatableTexture animatableTexture;
        boolean animated;
        NativeImage nativeImage;
        AbstractTexture originalTexture;
        try {
            originalTexture = (AbstractTexture)mc.m_18691_(() -> mc.m_91097_().m_118506_(this.textureBase)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to load original texture: " + this.textureBase, e);
        }
        Resource textureBaseResource = resourceManager.m_142591_(this.textureBase);
        if (originalTexture instanceof DynamicTexture) {
            DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
            nativeImage = dynamicTexture.m_117991_();
        } else {
            nativeImage = NativeImage.m_85058_((InputStream)textureBaseResource.m_6679_());
        }
        NativeImage baseImage = nativeImage;
        NativeImage glowImage = null;
        TextureMetadataSection textureBaseMeta = (TextureMetadataSection)textureBaseResource.m_5507_((MetadataSectionSerializer)TextureMetadataSection.f_119108_);
        boolean blur = textureBaseMeta != null && textureBaseMeta.m_119115_();
        boolean clamp = textureBaseMeta != null && textureBaseMeta.m_119116_();
        try {
            Resource glowLayerResource = resourceManager.m_142591_(this.glowLayer);
            GeoGlowingTextureMeta glowLayerMeta = null;
            if (glowLayerResource != null) {
                glowImage = NativeImage.m_85058_((InputStream)glowLayerResource.m_6679_());
                if (baseImage.m_84982_() != glowImage.m_84982_() || baseImage.m_85084_() != glowImage.m_85084_()) {
                    AzureLib.LOGGER.error("Glowmask size mismatch with base texture. Base size: {}x{}, Glowmask size: {}x{}, Location: {}", (Object)baseImage.m_84982_(), (Object)baseImage.m_85084_(), (Object)glowImage.m_84982_(), (Object)glowImage.m_85084_(), (Object)this.glowLayer);
                    return null;
                }
                glowLayerMeta = GeoGlowingTextureMeta.fromExistingImage(glowImage);
            } else {
                GeoGlowingTextureMeta meta = (GeoGlowingTextureMeta)textureBaseResource.m_5507_(GeoGlowingTextureMeta.DESERIALIZER);
                if (meta != null) {
                    glowLayerMeta = meta;
                    glowImage = new NativeImage(baseImage.m_84982_(), baseImage.m_85084_(), true);
                }
            }
            if (glowLayerMeta != null) {
                glowLayerMeta.createImageMask(baseImage, glowImage);
                if (Services.PLATFORM.isDevelopmentEnvironment()) {
                    this.printDebugImageToDisk(this.textureBase, baseImage);
                    this.printDebugImageToDisk(this.glowLayer, glowImage);
                }
            }
        }
        catch (IOException e) {
            AzureLib.LOGGER.warn("Resource failed to open for glowlayer meta: {}", (Object)this.glowLayer, (Object)e);
        }
        NativeImage mask = glowImage;
        if (mask == null) {
            String expectedGlowmask = this.textureBase.toString().replace(".png", "_glowmask.png");
            AzureLib.LOGGER.warn("Missing glowmask texture. Base texture: {}, Expected glowmask: {}", (Object)this.textureBase, (Object)expectedGlowmask);
            return null;
        }
        boolean bl = animated = originalTexture instanceof AnimatableTexture && (animatableTexture = (AnimatableTexture)originalTexture).isAnimated();
        if (animated) {
            ((AnimatableTexture)originalTexture).animationContents.animatedTexture.setGlowMaskTexture(this, baseImage, mask);
        }
        return () -> {
            if (!animated) {
                AutoGlowingTexture.uploadSimple(this.m_117963_(), mask, blur, clamp);
            }
            if (originalTexture instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
                dynamicTexture.m_117985_();
            } else {
                AutoGlowingTexture.uploadSimple(originalTexture.m_117963_(), baseImage, blur, clamp);
            }
        };
    }

    public static RenderType getRenderType(ResourceLocation texture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(texture), false);
    }

    public static RenderType getOutlineRenderType(ResourceLocation texture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(texture), true);
    }
}

