/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.layer;

import mod.azure.azurelib.cache.texture.AutoGlowingTexture;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mod.azure.azurelib.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AzAutoGlowingLayer<T>
implements AzRenderLayer<T> {
    @Override
    public void preRender(AzRendererPipelineContext<T> context) {
    }

    @Override
    public void render(AzRendererPipelineContext<T> context) {
        AzRendererPipeline<T> renderPipeline = context.rendererPipeline();
        RenderType renderType = this.determineRenderType(context);
        if (renderType != null) {
            context.setRenderType(renderType);
            context.setPackedLight(this.getPackedLight(context));
            context.setVertexConsumer(context.multiBufferSource().m_6299_(renderType));
            renderPipeline.reRender(context);
        }
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<T> context, AzBone bone) {
    }

    protected int getPackedLight(AzRendererPipelineContext<T> context) {
        return 0xF00000;
    }

    protected RenderType determineRenderType(AzRendererPipelineContext<T> context) {
        T animatable = context.animatable();
        AzRendererConfig<T> config = context.rendererPipeline().config();
        ResourceLocation textureLocation = config.textureLocation(animatable);
        if (!(animatable instanceof Entity)) {
            return AutoGlowingTexture.getRenderType(textureLocation);
        }
        Entity entity = (Entity)animatable;
        boolean isInvisible = entity.m_20145_();
        boolean appearsGlowing = Minecraft.m_91087_().m_91314_(entity);
        boolean isPlayerInvisible = entity.m_20177_(ClientUtils.getClientPlayer());
        if (isInvisible) {
            if (!isPlayerInvisible) {
                return RenderType.m_110467_((ResourceLocation)AutoGlowingTexture.getEmissiveResource(textureLocation));
            }
            if (appearsGlowing) {
                return RenderType.m_110491_((ResourceLocation)AutoGlowingTexture.getEmissiveResource(textureLocation));
            }
            return null;
        }
        if (appearsGlowing) {
            return AutoGlowingTexture.getOutlineRenderType(textureLocation);
        }
        return AutoGlowingTexture.getRenderType(textureLocation);
    }
}

