/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.client.DisplayAdapter;
import mod.azure.azurelib.client.DisplayAdapterManager;
import mod.azure.azurelib.client.screen.AbstractConfigScreen;
import mod.azure.azurelib.client.widget.ConfigEntryWidget;
import mod.azure.azurelib.config.adapter.TypeAdapter;
import mod.azure.azurelib.config.validate.NotificationSeverity;
import mod.azure.azurelib.config.value.ConfigValue;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends AbstractConfigScreen {
    private final Map<String, ConfigValue<?>> valueMap;

    public ConfigScreen(String ownerIdentifier, String configId, Map<String, ConfigValue<?>> valueMap, Screen previous) {
        this((Component)new TranslatableComponent("config.screen." + ownerIdentifier), configId, valueMap, previous);
    }

    public ConfigScreen(Component screenTitle, String configId, Map<String, ConfigValue<?>> valueMap, Screen previous) {
        super(screenTitle, previous, configId);
        this.valueMap = valueMap;
    }

    protected void m_7856_() {
        int viewportMin = 35;
        int viewportHeight = this.f_96544_ - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.valueMap.size());
        ArrayList values = new ArrayList(this.valueMap.values());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= values.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue value = (ConfigValue)values.get(i);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.m_142416_((GuiEventListener)new ConfigEntryWidget(30, 45 + j * 25 + (offset += correct), this.f_96543_ - 60, 20, value, this.configId));
            widget.setDescriptionRenderer(this::renderEntryDescription);
            TypeAdapter.AdapterContext context = value.getSerializationContext();
            Field field = context.getOwner();
            DisplayAdapter adapter = DisplayAdapterManager.forType(field.getType());
            if (adapter == null) {
                AzureLib.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)field.getType().getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(value, field, widget);
                this.initializeGuiValue(value, widget);
                continue;
            }
            catch (ClassCastException e) {
                AzureLib.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", (Object)field.getType().getSimpleName(), (Object)e);
            }
        }
        this.addFooter();
    }

    private void renderEntryDescription(PoseStack stack, AbstractWidget widget, NotificationSeverity severity, List<FormattedCharSequence> text) {
        int x = widget.f_93620_ + 5;
        int y = widget.f_93621_ + widget.m_93694_() + 10;
        if (!severity.isOkStatus()) {
            this.renderNotification(severity, stack, text, x, y);
        } else {
            this.renderNotification(NotificationSeverity.INFO, stack, text, x, y);
        }
    }

    public void m_6305_(@NotNull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_);
        float f = (float)(this.f_96543_ - titleWidth) / 2.0f;
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(stack, this.f_96539_, f, (float)(35 - 9) / 2.0f, 0xFFFFFF);
        ConfigScreen.m_93172_((PoseStack)stack, (int)0, (int)35, (int)this.f_96543_, (int)(this.f_96544_ - 30), (int)-1728053248);
        ConfigScreen.renderScrollbar(stack, this.f_96543_ - 5, 35, 5, this.f_96544_ - 30 - 35, this.index, this.valueMap.size(), this.pageSize);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.valueMap.size()) {
            this.index = next;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            return true;
        }
        return false;
    }
}

