/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.value;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import mod.azure.azurelib.config.Configurable;
import mod.azure.azurelib.config.adapter.TypeAdapter;
import mod.azure.azurelib.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.config.format.IConfigFormat;
import mod.azure.azurelib.config.value.ArrayValue;
import mod.azure.azurelib.config.value.ConfigValue;
import mod.azure.azurelib.config.value.ValueData;
import net.minecraft.network.FriendlyByteBuf;

public class EnumArrayValue<E extends Enum<E>>
extends ConfigValue<E[]>
implements ArrayValue {
    private boolean fixedSize;

    public EnumArrayValue(ValueData<E[]> value) {
        super(value);
    }

    @Override
    public boolean isFixedSize() {
        return this.fixedSize;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeEnumArray(this.getId(), (Enum[])this.get());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        Class<?> type = this.getValueType().getComponentType();
        this.set(format.readEnumArray(this.getId(), type));
    }

    @Override
    protected void readFieldData(Field field) {
        this.fixedSize = field.getAnnotation(Configurable.FixedSize.class) != null;
    }

    public static final class Adapter<E extends Enum<E>>
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new EnumArrayValue((ValueData<E[]>)ValueData.of(name, (Enum[])value, context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            Enum[] values = (Enum[])value.get();
            buffer.writeInt(values.length);
            for (Enum e : values) {
                buffer.m_130068_(e);
            }
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            int count = buffer.readInt();
            Class<?> type = value.getValueType().getComponentType();
            Enum[] enumArray = (Enum[])Array.newInstance(type, count);
            for (int i = 0; i < count; ++i) {
                enumArray[i] = buffer.m_130066_(type);
            }
            return enumArray;
        }
    }
}

