/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.model;

import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.model.AzBoneMetadata;
import mod.azure.azurelib.model.AzBoneSnapshot;

public class AzBone {
    private final AzBoneMetadata metadata;
    private final List<AzBone> children = new ObjectArrayList();
    private final List<GeoCube> cubes = new ObjectArrayList();
    private final Matrix4f modelSpaceMatrix = new Matrix4f();
    private final Matrix4f localSpaceMatrix = new Matrix4f();
    private final Matrix4f worldSpaceMatrix = new Matrix4f();
    private AzBoneSnapshot initialSnapshot;
    private boolean hidden;
    private boolean childrenHidden = false;
    private final Vector3f pivot;
    private final Vector3f position;
    private final Vector3f rotation;
    private final Vector3f scale;
    private boolean positionChanged = false;
    private boolean rotationChanged = false;
    private boolean scaleChanged = false;
    private Matrix3f worldSpaceNormal = new Matrix3f();
    private boolean trackingMatrices;

    public AzBone(AzBoneMetadata metadata) {
        this.metadata = metadata;
        this.trackingMatrices = false;
        this.hidden = metadata.dontRender() == Boolean.TRUE;
        this.position = new Vector3f();
        this.pivot = new Vector3f();
        this.rotation = new Vector3f();
        this.scale = new Vector3f(1.0f, 1.0f, 1.0f);
        this.worldSpaceNormal.m_8180_();
        this.worldSpaceMatrix.m_27624_();
        this.localSpaceMatrix.m_27624_();
        this.modelSpaceMatrix.m_27624_();
    }

    public String getName() {
        return this.metadata.name();
    }

    public AzBone getParent() {
        return this.metadata.parent();
    }

    public float getRotX() {
        return this.rotation.m_122239_();
    }

    public void setRotX(float value) {
        this.rotation.f_122228_ = value;
        this.markRotationAsChanged();
    }

    public float getRotY() {
        return this.rotation.m_122260_();
    }

    public void setRotY(float value) {
        this.rotation.f_122229_ = value;
        this.markRotationAsChanged();
    }

    public float getRotZ() {
        return this.rotation.m_122269_();
    }

    public void setRotZ(float value) {
        this.rotation.f_122230_ = value;
        this.markRotationAsChanged();
    }

    public void updateRotation(float xRot, float yRot, float zRot) {
        this.setRotX(xRot);
        this.setRotY(yRot);
        this.setRotZ(zRot);
    }

    public float getPosX() {
        return this.position.m_122239_();
    }

    public void setPosX(float value) {
        this.position.f_122228_ = value;
        this.markPositionAsChanged();
    }

    public float getPosY() {
        return this.position.m_122260_();
    }

    public void setPosY(float value) {
        this.position.f_122229_ = value;
        this.markPositionAsChanged();
    }

    public float getPosZ() {
        return this.position.m_122269_();
    }

    public void setPosZ(float value) {
        this.position.f_122230_ = value;
        this.markPositionAsChanged();
    }

    public void updatePosition(float posX, float posY, float posZ) {
        this.setPosX(posX);
        this.setPosY(posY);
        this.setPosZ(posZ);
    }

    public float getScaleX() {
        return this.scale.m_122239_();
    }

    public void setScaleX(float value) {
        this.scale.f_122228_ = value;
        this.markScaleAsChanged();
    }

    public float getScaleY() {
        return this.scale.m_122260_();
    }

    public void setScaleY(float value) {
        this.scale.f_122229_ = value;
        this.markScaleAsChanged();
    }

    public float getScaleZ() {
        return this.scale.m_122269_();
    }

    public void setScaleZ(float value) {
        this.scale.f_122230_ = value;
        this.markScaleAsChanged();
    }

    public void updateScale(float scaleX, float scaleY, float scaleZ) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        this.setScaleZ(scaleZ);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.setChildrenHidden(hidden);
    }

    public void setChildrenHidden(boolean hideChildren) {
        this.childrenHidden = hideChildren;
    }

    public float getPivotX() {
        return this.pivot.m_122239_();
    }

    public void setPivotX(float value) {
        this.pivot.f_122228_ = value;
    }

    public float getPivotY() {
        return this.pivot.m_122260_();
    }

    public void setPivotY(float value) {
        this.pivot.f_122229_ = value;
    }

    public float getPivotZ() {
        return this.pivot.m_122269_();
    }

    public void setPivotZ(float value) {
        this.pivot.f_122230_ = value;
    }

    public void updatePivot(float pivotX, float pivotY, float pivotZ) {
        this.setPivotX(pivotX);
        this.setPivotY(pivotY);
        this.setPivotZ(pivotZ);
    }

    public boolean isHidingChildren() {
        return this.childrenHidden;
    }

    public void markScaleAsChanged() {
        this.scaleChanged = true;
    }

    public void markRotationAsChanged() {
        this.rotationChanged = true;
    }

    public void markPositionAsChanged() {
        this.positionChanged = true;
    }

    public boolean hasScaleChanged() {
        return this.scaleChanged;
    }

    public boolean hasRotationChanged() {
        return this.rotationChanged;
    }

    public boolean hasPositionChanged() {
        return this.positionChanged;
    }

    public void resetStateChanges() {
        this.scaleChanged = false;
        this.rotationChanged = false;
        this.positionChanged = false;
    }

    public AzBoneSnapshot getInitialAzSnapshot() {
        return this.initialSnapshot;
    }

    public List<AzBone> getChildBones() {
        return this.children;
    }

    public void saveInitialSnapshot() {
        if (this.initialSnapshot == null) {
            this.initialSnapshot = new AzBoneSnapshot(this);
        }
    }

    public Boolean getMirror() {
        return this.metadata.mirror();
    }

    public Double getInflate() {
        return this.metadata.inflate();
    }

    public Boolean shouldNeverRender() {
        return this.metadata.dontRender();
    }

    public Boolean getReset() {
        return this.metadata.reset();
    }

    public List<GeoCube> getCubes() {
        return this.cubes;
    }

    public boolean isTrackingMatrices() {
        return this.trackingMatrices;
    }

    public void setTrackingMatrices(boolean trackingMatrices) {
        this.trackingMatrices = trackingMatrices;
    }

    public Matrix4f getModelSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.modelSpaceMatrix;
    }

    public void setModelSpaceMatrix(Matrix4f matrix) {
        this.modelSpaceMatrix.m_162210_(matrix);
    }

    public Matrix4f getLocalSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.localSpaceMatrix;
    }

    public void setLocalSpaceMatrix(Matrix4f matrix) {
        this.localSpaceMatrix.m_162210_(matrix);
    }

    public Matrix4f getWorldSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.worldSpaceMatrix;
    }

    public void setWorldSpaceMatrix(Matrix4f matrix) {
        this.worldSpaceMatrix.m_27644_(matrix);
    }

    public Matrix3f getWorldSpaceNormal() {
        return this.worldSpaceNormal;
    }

    public void setWorldSpaceNormal(Matrix3f matrix) {
        this.worldSpaceNormal = matrix;
    }

    public Vector3d getLocalPosition() {
        Matrix4f matrix = this.getLocalSpaceMatrix();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.m_123607_(matrix);
        return new Vector3d((double)vec.m_123601_(), (double)vec.m_123615_(), (double)vec.m_123616_());
    }

    public Vector3d getModelPosition() {
        Matrix4f matrix = this.getModelSpaceMatrix();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.m_123607_(matrix);
        return new Vector3d((double)(-vec.m_123601_() * 16.0f), (double)(vec.m_123615_() * 16.0f), (double)(vec.m_123616_() * 16.0f));
    }

    public void setModelPosition(Vector3d pos) {
        AzBone parent = this.getParent();
        Matrix4f identity = new Matrix4f();
        identity.m_27624_();
        Matrix4f matrix = parent == null ? identity : parent.getModelSpaceMatrix().m_27658_();
        matrix.m_27657_();
        Vector4f vec = new Vector4f(-((float)pos.f_86214_) / 16.0f, (float)pos.f_86215_ / 16.0f, (float)pos.f_86216_ / 16.0f, 1.0f);
        vec.m_123607_(matrix);
        this.updatePosition(-vec.m_123601_() * 16.0f, vec.m_123615_() * 16.0f, vec.m_123616_() * 16.0f);
    }

    public Vector3d getWorldPosition() {
        Matrix4f matrix = this.getWorldSpaceMatrix();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.m_123607_(matrix);
        return new Vector3d((double)vec.m_123601_(), (double)vec.m_123615_(), (double)vec.m_123616_());
    }

    public Matrix4f getModelRotationMatrix() {
        Matrix4f matrix = this.getModelSpaceMatrix().m_27658_();
        AzBone.removeMatrixTranslation(matrix);
        return matrix;
    }

    public static void removeMatrixTranslation(Matrix4f matrix) {
        matrix.f_27606_ = 0.0f;
        matrix.f_27610_ = 0.0f;
        matrix.f_27614_ = 0.0f;
    }

    public Vector3d getPositionVector() {
        return new Vector3d((double)this.getPosX(), (double)this.getPosY(), (double)this.getPosZ());
    }

    public Vector3d getRotationVector() {
        return new Vector3d((double)this.getRotX(), (double)this.getRotY(), (double)this.getRotZ());
    }

    public Vector3d getScaleVector() {
        return new Vector3d((double)this.getScaleX(), (double)this.getScaleY(), (double)this.getScaleZ());
    }

    public void addRotationOffsetFromBone(AzBone source) {
        this.setRotX(this.getRotX() + source.getRotX() - source.getInitialAzSnapshot().getRotX());
        this.setRotY(this.getRotY() + source.getRotY() - source.getInitialAzSnapshot().getRotY());
        this.setRotZ(this.getRotZ() + source.getRotZ() - source.getInitialAzSnapshot().getRotZ());
    }

    public AzBone deepCopy() {
        AzBone copy = new AzBone(this.metadata);
        copy.hidden = this.hidden;
        copy.childrenHidden = this.childrenHidden;
        copy.pivot.m_176768_(this.pivot);
        copy.position.m_176768_(this.position);
        copy.rotation.m_176768_(this.rotation);
        copy.scale.m_176768_(this.scale);
        copy.modelSpaceMatrix.m_162210_(this.modelSpaceMatrix);
        copy.localSpaceMatrix.m_162210_(this.localSpaceMatrix);
        copy.worldSpaceMatrix.m_162210_(this.worldSpaceMatrix);
        copy.cubes.addAll(this.cubes);
        for (AzBone child : this.children) {
            copy.children.add(child.deepCopy());
        }
        copy.saveInitialSnapshot();
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getParent() != null ? this.getParent().getName() : Integer.valueOf(0), this.getCubes().size(), this.getChildBones().size());
    }
}

