/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import mod.azure.azurelib.animation.AzAnimator;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.cache.object.GeoVertex;
import mod.azure.azurelib.model.AzBakedModel;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.item.AzItemRendererPipelineContext;
import mod.azure.azurelib.util.client.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class AzModelRenderer<K, T> {
    private final AzRendererPipeline<K, T> rendererPipeline;
    protected final AzLayerRenderer<K, T> layerRenderer;
    private IntIntPair entityTextureSize;

    public AzModelRenderer(AzRendererPipeline<K, T> rendererPipeline, AzLayerRenderer<K, T> layerRenderer) {
        this.layerRenderer = layerRenderer;
        this.rendererPipeline = rendererPipeline;
    }

    protected void render(AzRendererPipelineContext<K, T> context, boolean isReRender) {
        T animatable = context.animatable();
        AzBakedModel model = context.bakedModel();
        this.rendererPipeline.updateAnimatedTextureFrame(animatable);
        for (AzBone bone : model.getTopLevelBones()) {
            this.renderRecursively(context, bone, isReRender);
        }
        AzRendererConfig<K, T> config = this.rendererPipeline.config();
        config.renderEntry(context);
    }

    protected void renderRecursively(AzRendererPipelineContext<K, T> context, AzBone bone, boolean isReRender) {
        VertexConsumer buffer = context.vertexConsumer();
        MultiBufferSource bufferSource = context.multiBufferSource();
        PoseStack poseStack = context.poseStack();
        poseStack.m_85836_();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context, bone));
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, context.partialTick(), context.packedLight(), context.packedOverlay(), context.red(), context.green(), context.blue(), context.alpha())) {
            this.renderCubesOfBone(context, bone);
        }
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.m_85849_();
    }

    protected void renderCubesOfBone(AzRendererPipelineContext<K, T> context, AzBone bone) {
        if (bone.isHidden()) {
            return;
        }
        PoseStack poseStack = context.poseStack();
        for (GeoCube cube : bone.getCubes()) {
            poseStack.m_85836_();
            this.renderCube(context, cube);
            poseStack.m_85849_();
        }
    }

    protected void renderChildBones(AzRendererPipelineContext<K, T> context, AzBone bone, boolean isReRender) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (AzBone childBone : bone.getChildBones()) {
            this.renderRecursively(context, childBone, isReRender);
        }
    }

    protected void renderCube(AzRendererPipelineContext<K, T> context, GeoCube cube) {
        PoseStack poseStack = context.poseStack();
        RenderUtils.translateToPivotPoint(poseStack, cube);
        RenderUtils.rotateMatrixAroundCube(poseStack, cube);
        RenderUtils.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.m_85850_().m_85864_();
        Matrix4f poseState = poseStack.m_85850_().m_85861_();
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = quad.normal().m_122281_();
            normal.m_122249_(normalisedPoseState);
            RenderUtils.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(context, quad, poseState, normal);
        }
    }

    protected void createVerticesOfQuad(AzRendererPipelineContext<K, T> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        VertexConsumer buffer = context.vertexConsumer();
        int packedOverlay = context.packedOverlay();
        int packedLight = context.packedLight();
        IntIntPair boneTextureSize = context.computeTextureSize(context.getTextureOverride());
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = new Vector4f(position.m_122239_(), position.m_122260_(), position.m_122269_(), 1.0f);
            vector4f.m_123607_(poseState);
            if (context.getTextureOverride() != null && boneTextureSize != null && this.entityTextureSize != null) {
                float texU = vertex.texU() * (float)this.entityTextureSize.firstInt() / (float)boneTextureSize.firstInt();
                float texV = vertex.texV() * (float)this.entityTextureSize.secondInt() / (float)boneTextureSize.secondInt();
                context.vertexConsumer().m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), context.red(), context.green(), context.blue(), context.alpha(), texU, texV, context.packedOverlay(), context.packedLight(), normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
                continue;
            }
            buffer.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), context.red(), context.green(), context.blue(), context.alpha(), vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
        }
    }

    public boolean boneRenderOverride(PoseStack poseStack, AzBone bone, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        return false;
    }

    @Nullable
    public RenderType getRenderTypeOverrideForBone(AzBone bone, T animatable, ResourceLocation texturePath, MultiBufferSource bufferSource, float partialTick) {
        return null;
    }

    @Nullable
    public ResourceLocation getTextureOverrideForBone(AzBone bone, T animatable, float partialTick) {
        return null;
    }

    public void handleAnimation(AzAnimator<K, T> animator, T animatable, float partialTick) {
        animator.animate(animatable, partialTick);
    }

    public VertexConsumer getOrRefreshBufferRenderType(AzItemRendererPipelineContext context, AzBone bone, RenderType renderType) {
        VertexConsumer currentBuffer = context.multiBufferSource().m_6299_(renderType);
        MultiBufferSource bufferSource = context.multiBufferSource();
        if (currentBuffer instanceof BufferBuilder) {
            BufferBuilder builder = (BufferBuilder)currentBuffer;
            if (this.isBufferInactive(builder)) {
                return bufferSource.m_6299_(renderType);
            }
        } else if (currentBuffer instanceof OutlineBufferSource.EntityOutlineGenerator) {
            OutlineBufferSource.EntityOutlineGenerator outline = (OutlineBufferSource.EntityOutlineGenerator)currentBuffer;
            if (this.needsBufferRefresh(outline.f_109936_)) {
                return new OutlineBufferSource.EntityOutlineGenerator(bufferSource.m_6299_(renderType), 255, 255, 255, 255);
            }
        } else if (currentBuffer instanceof VertexMultiConsumer.Double) {
            VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)currentBuffer;
            VertexConsumer firstBuffer = pair.f_86171_;
            VertexConsumer secondBuffer = pair.f_86172_;
            boolean firstNeedsRefresh = this.needsBufferRefresh(firstBuffer);
            boolean secondNeedsRefresh = this.needsBufferRefresh(secondBuffer);
            if (firstNeedsRefresh || secondNeedsRefresh) {
                return new VertexMultiConsumer.Double(firstNeedsRefresh ? bufferSource.m_6299_(renderType) : firstBuffer, secondNeedsRefresh ? bufferSource.m_6299_(renderType) : secondBuffer);
            }
        }
        return currentBuffer;
    }

    public VertexConsumer getOrRefreshRenderBuffer(boolean isReRender, AzRendererPipelineContext<K, T> context, AzBone bone) {
        AzRendererConfig<K, T> config = this.rendererPipeline.config();
        VertexConsumer currentBuffer = context.vertexConsumer();
        MultiBufferSource bufferSource = context.multiBufferSource();
        RenderType renderType = context.renderType();
        if (config.boneTextureOverrideProvider(bone) != null) {
            context.setTextureOverride(config.boneTextureOverrideProvider(bone));
        }
        ResourceLocation texture = config.boneTextureOverrideProvider(bone);
        RenderType renderTypeOverride = config.boneRenderTypeOverrideProvider(bone);
        if (texture != null && renderTypeOverride == null) {
            renderTypeOverride = context.getDefaultRenderType(context.animatable(), texture, bufferSource, context.partialTick(), config.getRenderType(context.currentEntity(), context.animatable()), config.alpha(context.animatable()));
        }
        if (renderTypeOverride != null) {
            currentBuffer = context.multiBufferSource().m_6299_(renderTypeOverride);
        }
        if (isReRender) {
            return currentBuffer;
        }
        if (currentBuffer instanceof BufferBuilder) {
            BufferBuilder builder = (BufferBuilder)currentBuffer;
            if (this.isBufferInactive(builder)) {
                return bufferSource.m_6299_(renderType);
            }
        } else if (currentBuffer instanceof OutlineBufferSource.EntityOutlineGenerator) {
            OutlineBufferSource.EntityOutlineGenerator outline = (OutlineBufferSource.EntityOutlineGenerator)currentBuffer;
            if (this.needsBufferRefresh(outline.f_109936_)) {
                return new OutlineBufferSource.EntityOutlineGenerator(bufferSource.m_6299_(renderType), 255, 255, 255, 255);
            }
        } else if (currentBuffer instanceof VertexMultiConsumer.Double) {
            VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)currentBuffer;
            VertexConsumer firstBuffer = pair.f_86171_;
            VertexConsumer secondBuffer = pair.f_86172_;
            boolean firstNeedsRefresh = this.needsBufferRefresh(firstBuffer);
            boolean secondNeedsRefresh = this.needsBufferRefresh(secondBuffer);
            if (firstNeedsRefresh || secondNeedsRefresh) {
                return new VertexMultiConsumer.Double(firstNeedsRefresh ? bufferSource.m_6299_(renderType) : firstBuffer, secondNeedsRefresh ? bufferSource.m_6299_(renderType) : secondBuffer);
            }
        }
        return currentBuffer;
    }

    protected boolean needsBufferRefresh(VertexConsumer buffer) {
        if (buffer instanceof BufferBuilder) {
            BufferBuilder builder = (BufferBuilder)buffer;
            return this.isBufferInactive(builder);
        }
        if (buffer instanceof OutlineBufferSource.EntityOutlineGenerator) {
            OutlineBufferSource.EntityOutlineGenerator outline = (OutlineBufferSource.EntityOutlineGenerator)buffer;
            return this.needsBufferRefresh(outline.f_109936_);
        }
        if (buffer instanceof VertexMultiConsumer.Double) {
            VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)buffer;
            return this.needsBufferRefresh(pair.f_86171_) || this.needsBufferRefresh(pair.f_86172_);
        }
        return false;
    }

    protected boolean isBufferInactive(BufferBuilder builder) {
        return !builder.f_85661_;
    }

    public void cacheTexture(AzRendererPipelineContext<K, T> context) {
        this.entityTextureSize = context.computeTextureSize(this.rendererPipeline.config().textureLocation(context.currentEntity(), context.animatable()));
    }

    public void clearCacheTexture() {
        this.entityTextureSize = null;
    }
}

