/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.layer;

import java.util.function.Function;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.layer.AzRenderLayer;
import mod.azure.azurelib.util.client.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class AzBlockAndItemLayer<K, T>
implements AzRenderLayer<K, T> {
    protected final Function<AzBone, ItemStack> itemStackProvider;
    protected final Function<AzBone, BlockState> blockStateProvider;

    public AzBlockAndItemLayer() {
        this(bone -> null, bone -> null);
    }

    public AzBlockAndItemLayer(Function<AzBone, ItemStack> itemStackProvider, Function<AzBone, BlockState> blockStateProvider) {
        this.itemStackProvider = itemStackProvider;
        this.blockStateProvider = blockStateProvider;
    }

    @Override
    public void preRender(AzRendererPipelineContext<K, T> context) {
    }

    @Override
    public void render(AzRendererPipelineContext<K, T> context) {
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<K, T> context, AzBone bone) {
        T animatable = context.animatable();
        ItemStack stack = this.itemStackForBone(bone, animatable);
        BlockState blockState = this.blockStateForBone(bone, animatable);
        if (stack == null && blockState == null) {
            return;
        }
        context.poseStack().m_85836_();
        RenderUtils.translateAndRotateMatrixForBone(context.poseStack(), bone);
        if (stack != null) {
            this.renderItemForBone(context, bone, stack, animatable);
        }
        if (blockState != null) {
            this.renderBlockForBone(context, bone, blockState, animatable);
        }
        context.setVertexConsumer(context.multiBufferSource().m_6299_(context.renderType()));
        context.poseStack().m_85849_();
    }

    public ItemStack itemStackForBone(AzBone bone, T animatable) {
        return this.itemStackProvider.apply(bone);
    }

    public BlockState blockStateForBone(AzBone bone, T animatable) {
        return this.blockStateProvider.apply(bone);
    }

    protected ItemTransforms.TransformType getTransformTypeForStack(AzBone bone, ItemStack stack, T animatable) {
        return ItemTransforms.TransformType.NONE;
    }

    protected void renderItemForBone(AzRendererPipelineContext<K, T> context, AzBone bone, ItemStack itemStack, T animatable) {
        T t = context.animatable();
        if (t instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)t;
            Minecraft.m_91087_().m_91291_().m_174242_(livingEntity, itemStack, this.getTransformTypeForStack(bone, itemStack, animatable), false, context.poseStack(), context.multiBufferSource(), livingEntity.f_19853_, context.packedLight(), context.packedOverlay(), livingEntity.m_142049_());
        } else {
            Minecraft.m_91087_().m_91291_().m_174269_(itemStack, this.getTransformTypeForStack(bone, itemStack, animatable), context.packedLight(), context.packedOverlay(), context.poseStack(), context.multiBufferSource(), context.animatable().hashCode());
        }
    }

    protected void renderBlockForBone(AzRendererPipelineContext<K, T> context, AzBone bone, BlockState blockState, T animatable) {
        context.poseStack().m_85836_();
        context.poseStack().m_85837_(-0.25, -0.25, -0.25);
        context.poseStack().m_85841_(0.5f, 0.5f, 0.5f);
        Minecraft.m_91087_().m_91289_().m_110912_(blockState, context.poseStack(), context.multiBufferSource(), context.packedLight(), OverlayTexture.f_118083_);
        context.poseStack().m_85849_();
    }
}

