/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.rewrite.animation.impl.AzBlockAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzProvider;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererPipeline;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AzBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final AzProvider<T> provider = new AzProvider<BlockEntity>(config::createAnimator, config::modelLocation);
    private final AzBlockEntityRendererPipeline<T> rendererPipeline;
    @Nullable
    private AzBlockAnimator<T> reusedAzBlockAnimator;

    protected AzBlockEntityRenderer(AzBlockEntityRendererConfig<T> config) {
        this.rendererPipeline = this.createPipeline(config);
    }

    protected AzBlockEntityRendererPipeline<T> createPipeline(AzBlockEntityRendererConfig<T> config) {
        return new AzBlockEntityRendererPipeline<T>(config, this);
    }

    public void m_6922_(@NotNull T entity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource source, int packedLight, int packedOverlay) {
        AzBlockAnimator cachedEntityAnimator = (AzBlockAnimator)this.provider.provideAnimator(entity);
        AzBakedModel model = this.provider.provideBakedModel(entity);
        if (cachedEntityAnimator != null && model != null) {
            cachedEntityAnimator.setActiveModel(model);
        }
        this.reusedAzBlockAnimator = cachedEntityAnimator;
        this.rendererPipeline.render(poseStack, model, entity, source, null, null, 0.0f, partialTick, packedLight);
    }

    public AzBlockAnimator<T> getAnimator() {
        return this.reusedAzBlockAnimator;
    }
}

