/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.property.codec;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.animation.easing.AzEasingType;
import mod.azure.azurelib.animation.easing.AzEasingTypeRegistry;
import mod.azure.azurelib.animation.easing.AzEasingTypes;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehaviorRegistry;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelib.animation.property.AzAnimationStageProperties;
import net.minecraft.class_2540;

public class AzAnimationStagePropertiesCodec {
    public static final Function<class_2540, AzAnimationStageProperties> DECODER = buf -> {
        int propertyLength = buf.readByte();
        AzAnimationStageProperties properties = AzAnimationStageProperties.EMPTY;
        block10: for (int i = 0; i < propertyLength; ++i) {
            byte code = buf.readByte();
            switch (code) {
                case 0: {
                    Double animationSpeed = (Double)buf.method_43827(class_2540::readDouble);
                    properties = properties.withAnimationSpeed(animationSpeed != null ? animationSpeed : 1.0);
                    continue block10;
                }
                case 1: {
                    properties = properties.withTransitionLength(buf.readFloat());
                    continue block10;
                }
                case 2: {
                    AzEasingType easingType = AzEasingTypeRegistry.getOrDefault(buf.method_19772(), AzEasingTypes.NONE);
                    properties = properties.withEasingType(easingType);
                    continue block10;
                }
                case 3: {
                    AzPlayBehavior playBehavior = AzPlayBehaviorRegistry.getOrDefault(buf.method_19772(), AzPlayBehaviors.PLAY_ONCE);
                    properties = properties.withPlayBehavior(playBehavior);
                    continue block10;
                }
                case 4: {
                    Double startTickOffset = (Double)buf.method_43827(class_2540::readDouble);
                    properties = properties.withStartTickOffset(startTickOffset != null ? startTickOffset : 0.0);
                    continue block10;
                }
                case 5: {
                    properties = properties.withFreezeTickOffset(buf.readDouble());
                    continue block10;
                }
                case 6: {
                    properties = properties.withRepeatXTimes(buf.readDouble());
                    continue block10;
                }
                case 7: {
                    properties = properties.withShouldReverse(buf.readBoolean());
                }
            }
        }
        return properties;
    };
    public static final BiConsumer<class_2540, AzAnimationStageProperties> ENCODER = (buf, properties) -> {
        int propertyLength = 0;
        propertyLength += properties.hasAnimationSpeed() ? 1 : 0;
        propertyLength += properties.hasTransitionLength() ? 1 : 0;
        propertyLength += properties.hasEasingType() ? 1 : 0;
        propertyLength += properties.hasPlayBehavior() ? 1 : 0;
        propertyLength += properties.hasStartTickOffset() ? 1 : 0;
        propertyLength += properties.hasFreezeTickOffset() ? 1 : 0;
        propertyLength += properties.hasRepeatXTimes() ? 1 : 0;
        buf.writeByte(propertyLength += properties.hasReversing() ? 1 : 0);
        if (properties.hasAnimationSpeed()) {
            buf.writeByte(0);
            buf.writeDouble(properties.animationSpeed());
        }
        if (properties.hasTransitionLength()) {
            buf.writeByte(1);
            buf.writeFloat(properties.transitionLength());
        }
        if (properties.hasEasingType()) {
            buf.writeByte(2);
            buf.method_10814(properties.easingType().name());
        }
        if (properties.hasPlayBehavior()) {
            buf.writeByte(3);
            buf.method_10814(properties.playBehavior().name());
        }
        if (properties.hasStartTickOffset()) {
            buf.writeByte(4);
            buf.writeDouble(properties.startTickOffset());
        }
        if (properties.hasFreezeTickOffset()) {
            buf.writeByte(5);
            buf.writeDouble(properties.freezeTickOffset());
        }
        if (properties.hasRepeatXTimes()) {
            buf.writeByte(6);
            buf.writeDouble(properties.repeatXTimes());
        }
        if (properties.hasReversing()) {
            buf.writeByte(7);
            buf.writeBoolean(properties.isReversing());
        }
    };
}

