/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.model;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.model.AzBoneMetadata;
import mod.azure.azurelib.model.AzBoneSnapshot;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1161;
import net.minecraft.class_1162;
import net.minecraft.class_4581;

public class AzBone {
    private final AzBoneMetadata metadata;
    private final List<AzBone> children = new ObjectArrayList();
    private final List<GeoCube> cubes = new ObjectArrayList();
    private final class_1159 modelSpaceMatrix = new class_1159();
    private final class_1159 localSpaceMatrix = new class_1159();
    private final class_1159 worldSpaceMatrix = new class_1159();
    private AzBoneSnapshot initialSnapshot;
    private boolean hidden;
    private boolean childrenHidden = false;
    private final class_1160 pivot;
    private final class_1160 position;
    private final class_1160 rotation;
    private final class_1160 scale;
    private boolean positionChanged = false;
    private boolean rotationChanged = false;
    private boolean scaleChanged = false;
    private class_4581 worldSpaceNormal = new class_4581();
    private boolean trackingMatrices;

    public AzBone(AzBoneMetadata metadata) {
        this.metadata = metadata;
        this.trackingMatrices = false;
        this.hidden = metadata.dontRender() == Boolean.TRUE;
        this.position = new class_1160();
        this.pivot = new class_1160();
        this.rotation = new class_1160();
        this.scale = new class_1160(1.0f, 1.0f, 1.0f);
        this.worldSpaceNormal.method_22856();
        this.worldSpaceMatrix.method_22668();
        this.localSpaceMatrix.method_22668();
        this.modelSpaceMatrix.method_22668();
    }

    public String getName() {
        return this.metadata.name();
    }

    public AzBone getParent() {
        return this.metadata.parent();
    }

    public float getRotX() {
        return this.rotation.method_4943();
    }

    public void setRotX(float value) {
        this.rotation.field_21483 = value;
        this.markRotationAsChanged();
    }

    public float getRotY() {
        return this.rotation.method_4945();
    }

    public void setRotY(float value) {
        this.rotation.field_21484 = value;
        this.markRotationAsChanged();
    }

    public float getRotZ() {
        return this.rotation.method_4947();
    }

    public void setRotZ(float value) {
        this.rotation.field_21485 = value;
        this.markRotationAsChanged();
    }

    public void updateRotation(float xRot, float yRot, float zRot) {
        this.setRotX(xRot);
        this.setRotY(yRot);
        this.setRotZ(zRot);
    }

    public float getPosX() {
        return this.position.method_4943();
    }

    public void setPosX(float value) {
        this.position.field_21483 = value;
        this.markPositionAsChanged();
    }

    public float getPosY() {
        return this.position.method_4945();
    }

    public void setPosY(float value) {
        this.position.field_21484 = value;
        this.markPositionAsChanged();
    }

    public float getPosZ() {
        return this.position.method_4947();
    }

    public void setPosZ(float value) {
        this.position.field_21485 = value;
        this.markPositionAsChanged();
    }

    public void updatePosition(float posX, float posY, float posZ) {
        this.setPosX(posX);
        this.setPosY(posY);
        this.setPosZ(posZ);
    }

    public float getScaleX() {
        return this.scale.method_4943();
    }

    public void setScaleX(float value) {
        this.scale.field_21483 = value;
        this.markScaleAsChanged();
    }

    public float getScaleY() {
        return this.scale.method_4945();
    }

    public void setScaleY(float value) {
        this.scale.field_21484 = value;
        this.markScaleAsChanged();
    }

    public float getScaleZ() {
        return this.scale.method_4947();
    }

    public void setScaleZ(float value) {
        this.scale.field_21485 = value;
        this.markScaleAsChanged();
    }

    public void updateScale(float scaleX, float scaleY, float scaleZ) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        this.setScaleZ(scaleZ);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.setChildrenHidden(hidden);
    }

    public void setChildrenHidden(boolean hideChildren) {
        this.childrenHidden = hideChildren;
    }

    public float getPivotX() {
        return this.pivot.method_4943();
    }

    public void setPivotX(float value) {
        this.pivot.field_21483 = value;
    }

    public float getPivotY() {
        return this.pivot.method_4945();
    }

    public void setPivotY(float value) {
        this.pivot.field_21484 = value;
    }

    public float getPivotZ() {
        return this.pivot.method_4947();
    }

    public void setPivotZ(float value) {
        this.pivot.field_21485 = value;
    }

    public void updatePivot(float pivotX, float pivotY, float pivotZ) {
        this.setPivotX(pivotX);
        this.setPivotY(pivotY);
        this.setPivotZ(pivotZ);
    }

    public boolean isHidingChildren() {
        return this.childrenHidden;
    }

    public void markScaleAsChanged() {
        this.scaleChanged = true;
    }

    public void markRotationAsChanged() {
        this.rotationChanged = true;
    }

    public void markPositionAsChanged() {
        this.positionChanged = true;
    }

    public boolean hasScaleChanged() {
        return this.scaleChanged;
    }

    public boolean hasRotationChanged() {
        return this.rotationChanged;
    }

    public boolean hasPositionChanged() {
        return this.positionChanged;
    }

    public void resetStateChanges() {
        this.scaleChanged = false;
        this.rotationChanged = false;
        this.positionChanged = false;
    }

    public AzBoneSnapshot getInitialAzSnapshot() {
        return this.initialSnapshot;
    }

    public List<AzBone> getChildBones() {
        return this.children;
    }

    public void saveInitialSnapshot() {
        if (this.initialSnapshot == null) {
            this.initialSnapshot = new AzBoneSnapshot(this);
        }
    }

    public Boolean getMirror() {
        return this.metadata.mirror();
    }

    public Double getInflate() {
        return this.metadata.inflate();
    }

    public Boolean shouldNeverRender() {
        return this.metadata.dontRender();
    }

    public Boolean getReset() {
        return this.metadata.reset();
    }

    public List<GeoCube> getCubes() {
        return this.cubes;
    }

    public boolean isTrackingMatrices() {
        return this.trackingMatrices;
    }

    public void setTrackingMatrices(boolean trackingMatrices) {
        this.trackingMatrices = trackingMatrices;
    }

    public class_1159 getModelSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.modelSpaceMatrix;
    }

    public void setModelSpaceMatrix(class_1159 matrix) {
        this.modelSpaceMatrix.method_35434(matrix);
    }

    public class_1159 getLocalSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.localSpaceMatrix;
    }

    public void setLocalSpaceMatrix(class_1159 matrix) {
        this.localSpaceMatrix.method_35434(matrix);
    }

    public class_1159 getWorldSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.worldSpaceMatrix;
    }

    public void setWorldSpaceMatrix(class_1159 matrix) {
        this.worldSpaceMatrix.method_22672(matrix);
    }

    public class_4581 getWorldSpaceNormal() {
        return this.worldSpaceNormal;
    }

    public void setWorldSpaceNormal(class_4581 matrix) {
        this.worldSpaceNormal = matrix;
    }

    public class_1161 getLocalPosition() {
        class_1159 matrix = this.getLocalSpaceMatrix();
        class_1162 vec = new class_1162(0.0f, 0.0f, 0.0f, 1.0f);
        vec.method_22674(matrix);
        return new class_1161((double)vec.method_4953(), (double)vec.method_4956(), (double)vec.method_4957());
    }

    public class_1161 getModelPosition() {
        class_1159 matrix = this.getModelSpaceMatrix();
        class_1162 vec = new class_1162(0.0f, 0.0f, 0.0f, 1.0f);
        vec.method_22674(matrix);
        return new class_1161((double)(-vec.method_4953() * 16.0f), (double)(vec.method_4956() * 16.0f), (double)(vec.method_4957() * 16.0f));
    }

    public void setModelPosition(class_1161 pos) {
        AzBone parent = this.getParent();
        class_1159 identity = new class_1159();
        identity.method_22668();
        class_1159 matrix = parent == null ? identity : parent.getModelSpaceMatrix().method_22673();
        matrix.method_22870();
        class_1162 vec = new class_1162(-((float)pos.field_5661) / 16.0f, (float)pos.field_5660 / 16.0f, (float)pos.field_5659 / 16.0f, 1.0f);
        vec.method_22674(matrix);
        this.updatePosition(-vec.method_4953() * 16.0f, vec.method_4956() * 16.0f, vec.method_4957() * 16.0f);
    }

    public class_1161 getWorldPosition() {
        class_1159 matrix = this.getWorldSpaceMatrix();
        class_1162 vec = new class_1162(0.0f, 0.0f, 0.0f, 1.0f);
        vec.method_22674(matrix);
        return new class_1161((double)vec.method_4953(), (double)vec.method_4956(), (double)vec.method_4957());
    }

    public class_1159 getModelRotationMatrix() {
        class_1159 matrix = this.getModelSpaceMatrix().method_22673();
        AzBone.removeMatrixTranslation(matrix);
        return matrix;
    }

    public static void removeMatrixTranslation(class_1159 matrix) {
        matrix.field_21655 = 0.0f;
        matrix.field_21659 = 0.0f;
        matrix.field_21663 = 0.0f;
    }

    public class_1161 getPositionVector() {
        return new class_1161((double)this.getPosX(), (double)this.getPosY(), (double)this.getPosZ());
    }

    public class_1161 getRotationVector() {
        return new class_1161((double)this.getRotX(), (double)this.getRotY(), (double)this.getRotZ());
    }

    public class_1161 getScaleVector() {
        return new class_1161((double)this.getScaleX(), (double)this.getScaleY(), (double)this.getScaleZ());
    }

    public void addRotationOffsetFromBone(AzBone source) {
        this.setRotX(this.getRotX() + source.getRotX() - source.getInitialAzSnapshot().getRotX());
        this.setRotY(this.getRotY() + source.getRotY() - source.getInitialAzSnapshot().getRotY());
        this.setRotZ(this.getRotZ() + source.getRotZ() - source.getInitialAzSnapshot().getRotZ());
    }

    public AzBone deepCopy() {
        AzBone copy = new AzBone(this.metadata);
        copy.hidden = this.hidden;
        copy.childrenHidden = this.childrenHidden;
        copy.pivot.method_35920(this.pivot);
        copy.position.method_35920(this.position);
        copy.rotation.method_35920(this.rotation);
        copy.scale.method_35920(this.scale);
        copy.modelSpaceMatrix.method_35434(this.modelSpaceMatrix);
        copy.localSpaceMatrix.method_35434(this.localSpaceMatrix);
        copy.worldSpaceMatrix.method_35434(this.worldSpaceMatrix);
        copy.cubes.addAll(this.cubes);
        for (AzBone child : this.children) {
            copy.children.add(child.deepCopy());
        }
        copy.saveInitialSnapshot();
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getParent() != null ? this.getParent().getName() : Integer.valueOf(0), this.getCubes().size(), this.getChildBones().size());
    }
}

