/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.client.screen;

import java.util.List;
import java.util.Objects;
import mod.azure.azurelib.config.ConfigHolder;
import mod.azure.azurelib.config.client.DisplayAdapter;
import mod.azure.azurelib.config.client.screen.AbstractConfigScreen;
import mod.azure.azurelib.config.client.screen.ConfigScreen;
import mod.azure.azurelib.config.client.widget.ConfigEntryWidget;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ConfigGroupScreen
extends Screen {
    protected final Screen last;
    protected final String groupId;
    protected final List<ConfigHolder<?>> configHolders;
    protected int index;
    protected int pageSize;

    public ConfigGroupScreen(Screen last, String groupId, List<ConfigHolder<?>> configHolders) {
        super((Component)Component.m_237115_((String)"text.azurelib.screen.select_config"));
        this.last = last;
        this.groupId = groupId;
        this.configHolders = configHolders;
    }

    protected void m_7856_() {
        int viewportMin = 35;
        int viewportHeight = this.f_96544_ - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.configHolders.size());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        int posX = 30;
        int componentWidth = this.f_96543_ - 2 * posX;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.configHolders.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigHolder<?> value = this.configHolders.get(i);
            int y = 45 + j * 25 + (offset += correct);
            String configId = value.getConfigId();
            this.m_142416_((GuiEventListener)new LeftAlignedLabel(posX, y, componentWidth, 20, (Component)Component.m_237115_((String)("config.screen." + configId)), this.f_96547_));
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)ConfigEntryWidget.EDIT, btn -> {
                ConfigScreen screen = new ConfigScreen(configId, configId, value.getValueMap(), (Screen)this);
                this.f_96541_.m_91152_((Screen)screen);
            }).m_252794_(DisplayAdapter.getValueX(posX, componentWidth), y).m_253046_(DisplayAdapter.getValueWidth(componentWidth), 20).m_253136_());
        }
        this.initFooter();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_);
        int n = (int)((float)(this.f_96543_ - titleWidth) / 2.0f);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280614_(this.f_96547_, this.f_96539_, n, (int)((float)(35 - 9) / 2.0f), 0xFFFFFF, true);
        graphics.m_280509_(0, 35, this.f_96543_, this.f_96544_ - 30, -1728053248);
        AbstractConfigScreen.renderScrollbar(graphics, this.f_96543_ - 5, 35, 5, this.f_96544_ - 30 - 35, this.index, this.configHolders.size(), this.pageSize);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    protected void initFooter() {
        int centerY = this.f_96544_ - 30 + 5;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ConfigEntryWidget.BACK, btn -> this.f_96541_.m_91152_(this.last)).m_252794_(20, centerY).m_253046_(50, 20).m_253136_());
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.configHolders.size()) {
            this.index = next;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            return true;
        }
        return false;
    }

    protected static final class LeftAlignedLabel
    extends AbstractWidget {
        private final Font font;

        public LeftAlignedLabel(int x, int y, int width, int height, Component label, Font font) {
            super(x, y, width, height, label);
            this.font = font;
        }

        public void m_168797_(NarrationElementOutput narrationElementOutput) {
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            Component component = this.m_6035_();
            int n = this.m_252754_();
            int n2 = this.m_252907_();
            Objects.requireNonNull(this.font);
            graphics.m_280430_(this.font, component, n, n2 + (this.f_93619_ - 9) / 2, 0xAAAAAA);
        }

        protected boolean m_7972_(int p_230987_1_) {
            return false;
        }
    }
}

