/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.armor;

import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.animation.AzAnimator;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzModelRenderer;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.armor.AzArmorModelRenderer;
import mod.azure.azurelib.render.armor.AzArmorRendererPipeline;
import mod.azure.azurelib.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.render.armor.bone.AzArmorBoneProvider;
import mod.azure.azurelib.render.armor.bone.AzDefaultArmorBoneProvider;
import mod.azure.azurelib.render.layer.AzRenderLayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AzArmorRendererConfig
extends AzRendererConfig<UUID, ItemStack> {
    private final AzArmorBoneProvider boneProvider;

    private AzArmorRendererConfig(Supplier<AzAnimator<UUID, ItemStack>> animatorProvider, AzArmorBoneProvider boneProvider, BiFunction<Entity, ItemStack, ResourceLocation> modelLocationProvider, BiFunction<Entity, ItemStack, RenderType> renderTypeProvider, List<AzRenderLayer<UUID, ItemStack>> renderLayers, Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> preRenderEntry, Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> renderEntry, Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> postRenderEntry, BiFunction<Entity, ItemStack, ResourceLocation> textureLocationProvider, Function<ItemStack, Float> alphaFunction, Function<ItemStack, Float> scaleHeight, Function<ItemStack, Float> scaleWidth, BiFunction<AzRendererPipeline<UUID, ItemStack>, AzLayerRenderer<UUID, ItemStack>, AzModelRenderer<UUID, ItemStack>> modelRendererProvider, Function<AzRendererPipeline<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> pipelineContextFunction, Function<AzBone, ResourceLocation> boneTextureOverrideProvider, Function<AzBone, RenderType> boneRenderTypeOverrideProvider) {
        super(animatorProvider, modelLocationProvider, modelRendererProvider, pipelineContextFunction, renderTypeProvider, renderLayers, preRenderEntry, renderEntry, postRenderEntry, textureLocationProvider, alphaFunction, scaleHeight, scaleWidth, boneTextureOverrideProvider, boneRenderTypeOverrideProvider);
        this.boneProvider = boneProvider;
    }

    public AzArmorBoneProvider boneProvider() {
        return this.boneProvider;
    }

    public static Builder builder(ResourceLocation modelLocation, ResourceLocation textureLocation) {
        return new Builder((a, b) -> modelLocation, (a, b) -> textureLocation);
    }

    public static Builder builder(BiFunction<@Nullable Entity, ItemStack, ResourceLocation> modelLocationProvider, BiFunction<@Nullable Entity, ItemStack, ResourceLocation> textureLocationProvider) {
        return new Builder(modelLocationProvider, textureLocationProvider);
    }

    public static class Builder
    extends AzRendererConfig.Builder<UUID, ItemStack> {
        private AzArmorBoneProvider boneProvider = new AzDefaultArmorBoneProvider();

        protected Builder(BiFunction<@Nullable Entity, ItemStack, ResourceLocation> modelLocationProvider, BiFunction<@Nullable Entity, ItemStack, ResourceLocation> textureLocationProvider) {
            super(modelLocationProvider, textureLocationProvider);
            this.modelRendererProvider = (entityRendererPipeline, layer) -> new AzArmorModelRenderer((AzArmorRendererPipeline)entityRendererPipeline, (AzLayerRenderer<UUID, ItemStack>)layer);
            this.pipelineContextFunction = AzArmorRendererPipelineContext::new;
            this.renderTypeProvider = (a, b) -> RenderType.m_110458_((ResourceLocation)((ResourceLocation)textureLocationProvider.apply((Entity)a, (ItemStack)b)));
        }

        public Builder setBoneRenderTypeOverrideProvider(Function<AzBone, RenderType> boneRenderTypeOverrideProvider) {
            return (Builder)super.setBoneRenderTypeOverrideProvider(boneRenderTypeOverrideProvider);
        }

        public Builder setBoneTextureOverrideProvider(Function<AzBone, ResourceLocation> boneTextureOverrideProvider) {
            return (Builder)super.setBoneTextureOverrideProvider(boneTextureOverrideProvider);
        }

        public Builder setModelRenderer(BiFunction<AzRendererPipeline<UUID, ItemStack>, AzLayerRenderer<UUID, ItemStack>, AzModelRenderer<UUID, ItemStack>> modelRendererProvider) {
            return (Builder)super.setModelRenderer(modelRendererProvider);
        }

        public Builder setPipelineContext(Function<AzRendererPipeline<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> azRendererPipelineAzRendererPipelineContextFunction) {
            return (Builder)super.setPipelineContext(azRendererPipelineAzRendererPipelineContextFunction);
        }

        public Builder addRenderLayer(AzRenderLayer<UUID, ItemStack> renderLayer) {
            return (Builder)super.addRenderLayer(renderLayer);
        }

        public Builder setRenderType(RenderType renderType) {
            this.renderTypeProvider = (a, b) -> renderType;
            return this;
        }

        public Builder setRenderType(BiFunction<Entity, ItemStack, RenderType> renderTypeProvider) {
            this.renderTypeProvider = renderTypeProvider;
            return this;
        }

        public Builder setAnimatorProvider(Supplier<@Nullable AzAnimator<UUID, ItemStack>> animatorProvider) {
            return (Builder)super.setAnimatorProvider(animatorProvider);
        }

        public Builder setPrerenderEntry(Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> preRenderEntry) {
            return (Builder)super.setPrerenderEntry(preRenderEntry);
        }

        public Builder setRenderEntry(Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> renderEntry) {
            return (Builder)super.setRenderEntry(renderEntry);
        }

        public Builder setPostRenderEntry(Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> preRenderEntry) {
            return (Builder)super.setPostRenderEntry(preRenderEntry);
        }

        public Builder setAlpha(Function<ItemStack, Float> alphaFunction) {
            return (Builder)super.setAlpha(alphaFunction);
        }

        public Builder setAlpha(float alpha) {
            return (Builder)super.setAlpha(alpha);
        }

        public Builder setScale(Function<ItemStack, Float> scaleFunction) {
            return (Builder)super.setScale(scaleFunction);
        }

        public Builder setScale(Function<ItemStack, Float> scaleHeightFunction, Function<ItemStack, Float> scaleWidthFunction) {
            return (Builder)super.setScale(scaleHeightFunction, scaleWidthFunction);
        }

        public Builder setScale(float scale) {
            return (Builder)super.setScale(scale);
        }

        public Builder setScale(float scaleWidth, float scaleHeight) {
            return (Builder)super.setScale(scaleWidth, scaleHeight);
        }

        public Builder setBoneProvider(AzArmorBoneProvider boneProvider) {
            this.boneProvider = boneProvider;
            return this;
        }

        public AzArmorRendererConfig build() {
            AzRendererConfig baseConfig = super.build();
            return new AzArmorRendererConfig(baseConfig::createAnimator, this.boneProvider, baseConfig::modelLocation, baseConfig::getRenderType, baseConfig.renderLayers(), baseConfig::preRenderEntry, baseConfig::renderEntry, baseConfig::postRenderEntry, baseConfig::textureLocation, baseConfig::alpha, baseConfig::scaleHeight, baseConfig::scaleWidth, baseConfig::modelRendererProvider, baseConfig::pipelineContext, baseConfig::boneTextureOverrideProvider, baseConfig::boneRenderTypeOverrideProvider);
        }
    }
}

