/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.item;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mod.azure.azurelib.animation.AzAnimator;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzModelRenderer;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.item.AzItemModelRenderer;
import mod.azure.azurelib.render.item.AzItemRendererPipeline;
import mod.azure.azurelib.render.item.AzItemRendererPipelineContext;
import mod.azure.azurelib.render.layer.AzRenderLayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AzItemRendererConfig
extends AzRendererConfig<UUID, ItemStack> {
    private final boolean useEntityGuiLighting;
    private final boolean useNewOffset;
    private final Predicate<ItemDisplayContext> shouldAnimateInContext;

    private AzItemRendererConfig(Supplier<AzAnimator<UUID, ItemStack>> animatorProvider, Function<ItemStack, ResourceLocation> modelLocationProvider, Function<ItemStack, RenderType> renderTypeProvider, List<AzRenderLayer<UUID, ItemStack>> renderLayers, Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> preRenderEntry, Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> renderEntry, Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> postRenderEntry, Function<ItemStack, ResourceLocation> textureLocationProvider, Function<ItemStack, Float> alphaFunction, Function<ItemStack, Float> scaleHeight, Function<ItemStack, Float> scaleWidth, boolean useEntityGuiLighting, boolean useNewOffset, Predicate<ItemDisplayContext> shouldAnimateInContext, BiFunction<AzRendererPipeline<UUID, ItemStack>, AzLayerRenderer<UUID, ItemStack>, AzModelRenderer<UUID, ItemStack>> modelRendererProvider, Function<AzRendererPipeline<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> pipelineContextFunction, Function<AzBone, ResourceLocation> boneTextureOverrideProvider, Function<AzBone, RenderType> boneRenderTypeOverrideProvider) {
        super(animatorProvider, (a, b) -> (ResourceLocation)modelLocationProvider.apply((ItemStack)b), modelRendererProvider, pipelineContextFunction, (a, b) -> (RenderType)renderTypeProvider.apply((ItemStack)b), renderLayers, preRenderEntry, renderEntry, postRenderEntry, (a, b) -> (ResourceLocation)textureLocationProvider.apply((ItemStack)b), alphaFunction, scaleHeight, scaleWidth, boneTextureOverrideProvider, boneRenderTypeOverrideProvider);
        this.useEntityGuiLighting = useEntityGuiLighting;
        this.useNewOffset = useNewOffset;
        this.shouldAnimateInContext = shouldAnimateInContext;
    }

    public boolean useEntityGuiLighting() {
        return this.useEntityGuiLighting;
    }

    public boolean useNewOffset() {
        return this.useNewOffset;
    }

    public boolean shouldAnimateInContext(ItemDisplayContext context) {
        return this.shouldAnimateInContext.test(context);
    }

    public static Builder builder(ResourceLocation modelLocation, ResourceLocation textureLocation) {
        return new Builder($ -> modelLocation, $ -> textureLocation);
    }

    public static Builder builder(Function<ItemStack, ResourceLocation> modelLocationProvider, Function<ItemStack, ResourceLocation> textureLocationProvider) {
        return new Builder(modelLocationProvider, textureLocationProvider);
    }

    public static class Builder
    extends AzRendererConfig.Builder<UUID, ItemStack> {
        private boolean useEntityGuiLighting;
        private boolean useNewOffset;
        private Predicate<ItemDisplayContext> shouldAnimateInContext;

        protected Builder(Function<ItemStack, ResourceLocation> modelLocationProvider, Function<ItemStack, ResourceLocation> textureLocationProvider) {
            super((Entity a, T b) -> (ResourceLocation)modelLocationProvider.apply((ItemStack)b), (Entity a, T b) -> (ResourceLocation)textureLocationProvider.apply((ItemStack)b));
            this.renderTypeProvider = (a, b) -> RenderType.m_110458_((ResourceLocation)((ResourceLocation)textureLocationProvider.apply((ItemStack)b)));
            this.useEntityGuiLighting = false;
            this.useNewOffset = false;
            this.shouldAnimateInContext = $ -> true;
            this.modelRendererProvider = (entityRendererPipeline, layer) -> new AzItemModelRenderer((AzItemRendererPipeline)entityRendererPipeline, (AzLayerRenderer<UUID, ItemStack>)layer);
            this.pipelineContextFunction = AzItemRendererPipelineContext::new;
        }

        public Builder setBoneRenderTypeOverrideProvider(Function<AzBone, RenderType> boneRenderTypeOverrideProvider) {
            return (Builder)super.setBoneRenderTypeOverrideProvider(boneRenderTypeOverrideProvider);
        }

        public Builder setBoneTextureOverrideProvider(Function<AzBone, ResourceLocation> boneTextureOverrideProvider) {
            return (Builder)super.setBoneTextureOverrideProvider(boneTextureOverrideProvider);
        }

        public Builder setModelRenderer(BiFunction<AzRendererPipeline<UUID, ItemStack>, AzLayerRenderer<UUID, ItemStack>, AzModelRenderer<UUID, ItemStack>> modelRendererProvider) {
            return (Builder)super.setModelRenderer(modelRendererProvider);
        }

        public Builder setPipelineContext(Function<AzRendererPipeline<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> azRendererPipelineAzRendererPipelineContextFunction) {
            return (Builder)super.setPipelineContext(azRendererPipelineAzRendererPipelineContextFunction);
        }

        public Builder addRenderLayer(AzRenderLayer<UUID, ItemStack> renderLayer) {
            return (Builder)super.addRenderLayer(renderLayer);
        }

        public Builder setRenderType(RenderType renderType) {
            this.renderTypeProvider = (a, b) -> renderType;
            return this;
        }

        public Builder setRenderType(Function<ItemStack, RenderType> renderTypeProvider) {
            this.renderTypeProvider = (a, b) -> (RenderType)renderTypeProvider.apply((ItemStack)b);
            return this;
        }

        public Builder setRenderType(BiFunction<Entity, ItemStack, RenderType> renderTypeProvider) {
            this.renderTypeProvider = renderTypeProvider;
            return this;
        }

        public Builder setPrerenderEntry(Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> preRenderEntry) {
            return (Builder)super.setPrerenderEntry(preRenderEntry);
        }

        public Builder setRenderEntry(Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> renderEntry) {
            return (Builder)super.setRenderEntry(renderEntry);
        }

        public Builder setPostRenderEntry(Function<AzRendererPipelineContext<UUID, ItemStack>, AzRendererPipelineContext<UUID, ItemStack>> preRenderEntry) {
            return (Builder)super.setPostRenderEntry(preRenderEntry);
        }

        public Builder setAnimatorProvider(Supplier<@Nullable AzAnimator<UUID, ItemStack>> animatorProvider) {
            return (Builder)super.setAnimatorProvider(animatorProvider);
        }

        public Builder setAlpha(Function<ItemStack, Float> alphaFunction) {
            return (Builder)super.setAlpha(alphaFunction);
        }

        public Builder setAlpha(float alpha) {
            return (Builder)super.setAlpha(alpha);
        }

        public Builder setScale(Function<ItemStack, Float> scaleFunction) {
            return (Builder)super.setScale(scaleFunction);
        }

        public Builder setScale(Function<ItemStack, Float> scaleHeightFunction, Function<ItemStack, Float> scaleWidthFunction) {
            return (Builder)super.setScale(scaleHeightFunction, scaleWidthFunction);
        }

        public Builder setScale(float scale) {
            return (Builder)super.setScale(scale);
        }

        public Builder setScale(float scaleWidth, float scaleHeight) {
            return (Builder)super.setScale(scaleWidth, scaleHeight);
        }

        public Builder useEntityGuiLighting() {
            this.useEntityGuiLighting = true;
            return this;
        }

        public Builder useNewOffset(boolean useNewOffset) {
            this.useNewOffset = useNewOffset;
            return this;
        }

        public Builder setShouldAnimateInContext(Predicate<ItemDisplayContext> shouldAnimateInContext) {
            this.shouldAnimateInContext = shouldAnimateInContext;
            return this;
        }

        public Builder disableAnimationInContexts(ItemDisplayContext contextToDisable, ItemDisplayContext ... contextsToDisable) {
            HashSet<ItemDisplayContext> disabledContexts = new HashSet<ItemDisplayContext>();
            disabledContexts.add(contextToDisable);
            if (contextsToDisable.length > 0) {
                disabledContexts.addAll(Arrays.asList(contextsToDisable));
            }
            Set finalDisabledContexts = Set.copyOf(disabledContexts);
            this.shouldAnimateInContext = context -> !finalDisabledContexts.contains(context);
            return this;
        }

        public Builder enableAnimationOnlyInContexts(ItemDisplayContext contextToEnable, ItemDisplayContext ... contextsToEnable) {
            HashSet<ItemDisplayContext> enabledContexts = new HashSet<ItemDisplayContext>();
            enabledContexts.add(contextToEnable);
            if (contextsToEnable.length > 0) {
                enabledContexts.addAll(Arrays.asList(contextsToEnable));
            }
            Set finalEnabledContexts = Set.copyOf(enabledContexts);
            this.shouldAnimateInContext = finalEnabledContexts::contains;
            return this;
        }

        public Builder disableAnimationInAllContexts() {
            this.shouldAnimateInContext = context -> false;
            return this;
        }

        public AzItemRendererConfig build() {
            AzRendererConfig baseConfig = super.build();
            return new AzItemRendererConfig(baseConfig::createAnimator, baseConfig::modelLocation, baseConfig::getRenderType, baseConfig.renderLayers(), baseConfig::preRenderEntry, baseConfig::renderEntry, baseConfig::postRenderEntry, baseConfig::textureLocation, baseConfig::alpha, baseConfig::scaleHeight, baseConfig::scaleWidth, this.useEntityGuiLighting, this.useNewOffset, this.shouldAnimateInContext, baseConfig::modelRendererProvider, baseConfig::pipelineContext, baseConfig::boneTextureOverrideProvider, baseConfig::boneRenderTypeOverrideProvider);
        }
    }
}

