/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.client;

import java.util.regex.Pattern;
import mod.azure.azurelib.config.value.DecimalValue;
import mod.azure.azurelib.config.value.IntegerValue;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;

public final class ClientErrors {
    public static final MutableComponent CHAR_VALUE_EMPTY = new TranslatableComponent("text.azurelib.error.character_value_empty");
    private static final String KEY_NAN = "text.azurelib.error.nan";
    private static final String KEY_NUM_BOUNDS = "text.azurelib.error.num_bounds";
    private static final String KEY_MISMATCHED_PATTERN = "text.azurelib.error.pattern_mismatch";

    public static MutableComponent notANumber(String value) {
        return new TranslatableComponent(KEY_NAN, new Object[]{value});
    }

    public static MutableComponent outOfBounds(int i, IntegerValue.Range range) {
        return new TranslatableComponent(KEY_NUM_BOUNDS, new Object[]{i, range.min(), range.max()});
    }

    public static MutableComponent outOfBounds(long i, IntegerValue.Range range) {
        return new TranslatableComponent(KEY_NUM_BOUNDS, new Object[]{i, range.min(), range.max()});
    }

    public static MutableComponent outOfBounds(float i, DecimalValue.Range range) {
        return new TranslatableComponent(KEY_NUM_BOUNDS, new Object[]{Float.valueOf(i), range.min(), range.max()});
    }

    public static MutableComponent outOfBounds(double i, DecimalValue.Range range) {
        return new TranslatableComponent(KEY_NUM_BOUNDS, new Object[]{i, range.min(), range.max()});
    }

    public static MutableComponent invalidText(String text, Pattern pattern) {
        return new TranslatableComponent(KEY_MISMATCHED_PATTERN, new Object[]{text, pattern});
    }
}

