/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.model.AzBakedModel;
import mod.azure.azurelib.render.armor.AzArmorRendererConfig;
import mod.azure.azurelib.render.armor.AzArmorRendererPipeline;
import mod.azure.azurelib.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.render.armor.bone.AzArmorBoneContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzArmorModel<E extends LivingEntity>
extends HumanoidModel<E> {
    private final AzArmorRendererPipeline rendererPipeline;

    public AzArmorModel(AzArmorRendererPipeline rendererPipeline) {
        super(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_));
        this.rendererPipeline = rendererPipeline;
        this.f_102610_ = false;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        boolean shouldOutline;
        Minecraft mc = Minecraft.m_91087_();
        AzArmorRendererPipelineContext context = this.rendererPipeline.context();
        Entity currentEntity = context.currentEntity();
        ItemStack currentStack = context.currentStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().f_91060_.f_109464_.m_110104_();
        boolean bl = shouldOutline = Minecraft.m_91087_().f_91060_.m_109817_() && mc.m_91314_(currentEntity);
        if (shouldOutline) {
            bufferSource = Minecraft.m_91087_().f_91060_.f_109464_.m_110109_();
        }
        AzArmorRendererConfig config = this.rendererPipeline.config();
        ItemStack animatable = (ItemStack)context.animatable();
        float partialTick = mc.m_91296_();
        ResourceLocation textureLocation = config.textureLocation(currentEntity, animatable);
        RenderType renderType = context.getDefaultRenderType(animatable, textureLocation, (MultiBufferSource)bufferSource, partialTick, config.getRenderType(currentEntity, animatable), config.alpha(animatable));
        buffer = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)false, (boolean)currentStack.m_41790_());
        AzBakedModel model = this.rendererPipeline.renderer().provider().provideBakedModel(currentEntity, animatable);
        this.rendererPipeline.render(poseStack, model, animatable, (MultiBufferSource)bufferSource, null, buffer, 0.0f, partialTick, packedLight);
    }

    public void applyBaseModel(HumanoidModel<?> baseModel) {
        this.f_102610_ = baseModel.f_102610_;
        this.f_102817_ = baseModel.f_102817_;
        this.f_102609_ = baseModel.f_102609_;
        this.f_102816_ = baseModel.f_102816_;
        this.f_102815_ = baseModel.f_102815_;
    }

    public void m_8009_(boolean pVisible) {
        super.m_8009_(pVisible);
        AzArmorBoneContext boneContext = this.rendererPipeline.context().boneContext();
        boneContext.setAllVisible(pVisible);
    }
}

