/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.cache.texture;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.cache.texture.AnimatableTexture;
import mod.azure.azurelib.common.internal.common.cache.texture.AzAbstractTexture;
import mod.azure.azurelib.common.internal.common.cache.texture.GeoGlowingTextureMeta;
import mod.azure.azurelib.common.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class AutoGlowingTexture
extends AzAbstractTexture {
    protected final ResourceLocation textureBase;
    protected final ResourceLocation glowLayer;

    public AutoGlowingTexture(ResourceLocation originalLocation, ResourceLocation location) {
        super(originalLocation);
        this.textureBase = originalLocation;
        this.glowLayer = location;
    }

    @Override
    @Nullable
    protected RenderCall loadTexture(ResourceManager resourceManager, Minecraft mc) throws IOException {
        AnimatableTexture animatableTexture;
        boolean animated;
        NativeImage nativeImage;
        AbstractTexture originalTexture;
        try {
            originalTexture = (AbstractTexture)mc.submit(() -> mc.getTextureManager().getTexture(this.textureBase)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to load original texture: " + String.valueOf(this.textureBase), e);
        }
        Resource textureBaseResource = (Resource)resourceManager.getResource(this.textureBase).get();
        if (originalTexture instanceof DynamicTexture) {
            DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
            nativeImage = dynamicTexture.getPixels();
        } else {
            nativeImage = NativeImage.read((InputStream)textureBaseResource.open());
        }
        NativeImage baseImage = nativeImage;
        NativeImage glowImage = null;
        Optional textureBaseMeta = textureBaseResource.metadata().getSection((MetadataSectionSerializer)TextureMetadataSection.SERIALIZER);
        boolean blur = textureBaseMeta.isPresent() && ((TextureMetadataSection)textureBaseMeta.get()).isBlur();
        boolean clamp = textureBaseMeta.isPresent() && ((TextureMetadataSection)textureBaseMeta.get()).isClamp();
        try {
            Optional glowLayerResource = resourceManager.getResource(this.glowLayer);
            GeoGlowingTextureMeta glowLayerMeta = null;
            if (glowLayerResource.isPresent()) {
                glowImage = NativeImage.read((InputStream)((Resource)glowLayerResource.get()).open());
                if (baseImage.getWidth() != glowImage.getWidth() || baseImage.getHeight() != glowImage.getHeight()) {
                    AzureLib.LOGGER.error("Glowmask size mismatch with base texture. Base size: {}x{}, Glowmask size: {}x{}, Location: {}", (Object)baseImage.getWidth(), (Object)baseImage.getHeight(), (Object)glowImage.getWidth(), (Object)glowImage.getHeight(), (Object)this.glowLayer);
                    return null;
                }
                glowLayerMeta = GeoGlowingTextureMeta.fromExistingImage(glowImage);
            } else {
                Optional meta = textureBaseResource.metadata().getSection(GeoGlowingTextureMeta.DESERIALIZER);
                if (meta.isPresent()) {
                    glowLayerMeta = (GeoGlowingTextureMeta)meta.get();
                    glowImage = new NativeImage(baseImage.getWidth(), baseImage.getHeight(), true);
                }
            }
            if (glowLayerMeta != null) {
                glowLayerMeta.createImageMask(baseImage, glowImage);
                if (Services.PLATFORM.isDevelopmentEnvironment()) {
                    this.printDebugImageToDisk(this.textureBase, baseImage);
                    this.printDebugImageToDisk(this.glowLayer, glowImage);
                }
            }
        }
        catch (IOException e) {
            AzureLib.LOGGER.warn("Resource failed to open for glowlayer meta: {}", (Object)this.glowLayer, (Object)e);
        }
        NativeImage mask = glowImage;
        if (mask == null) {
            String expectedGlowmask = this.textureBase.toString().replace(".png", "_glowmask.png");
            AzureLib.LOGGER.warn("Missing glowmask texture. Base texture: {}, Expected glowmask: {}", (Object)this.textureBase, (Object)expectedGlowmask);
            return null;
        }
        boolean bl = animated = originalTexture instanceof AnimatableTexture && (animatableTexture = (AnimatableTexture)originalTexture).isAnimated();
        if (animated) {
            ((AnimatableTexture)originalTexture).animationContents.animatedTexture.setGlowMaskTexture(this, baseImage, mask);
        }
        return () -> {
            if (!animated) {
                AutoGlowingTexture.uploadSimple(this.getId(), mask, blur, clamp);
            }
            if (originalTexture instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
                dynamicTexture.upload();
            } else {
                AutoGlowingTexture.uploadSimple(originalTexture.getId(), baseImage, blur, clamp);
            }
        };
    }
}

